% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dummies_GVS.R
\name{add_dummies_GVS}
\alias{add_dummies_GVS}
\title{Add dummy predictors to the original predictor matrix, as required by the T-Rex+GVS selector}
\usage{
add_dummies_GVS(X, num_dummies, corr_max = 0.5)
}
\arguments{
\item{X}{Real valued predictor matrix.}

\item{num_dummies}{Number of dummies that are appended to the predictor matrix. Has to be a multiple of the number of original variables.}

\item{corr_max}{Maximum allowed correlation between any two predictors from different clusters.}
}
\value{
Enlarged predictor matrix for the T-Rex+GVS selector.
}
\description{
Generate num_dummies dummy predictors as required for the T-Rex+GVS selector and append them to the predictor matrix X.
}
\examples{
set.seed(123)
n <- 50
p <- 100
X <- matrix(stats::rnorm(n * p), nrow = n, ncol = p)
add_dummies_GVS(X = X, num_dummies = p)
}
