% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kFWER_LocalTest.R
\name{kFWER_LocalTest}
\alias{kFWER_LocalTest}
\title{kFWER_LocalTest. Computes the largest rejection set possible with kFWER control.}
\usage{
kFWER_LocalTest(LocalTest, pvals, k, alpha = 0.05, verbose = FALSE)
}
\arguments{
\item{LocalTest}{A function that returns a p-value for a joint hypothesis test.}

\item{pvals}{A vector p-values.}

\item{k}{An integer denoting the desired k at which to control the kFWER.}

\item{alpha}{Significance level.}

\item{verbose}{Logical, indicating whether or not to print progress.}
}
\value{
The number of marginal hypotheses that can be rejected with kFWER control.
}
\description{
kFWER_LocalTest. Computes the largest rejection set possible with kFWER control.
}
\examples{
nfalse = 50
m = 100
pvals = c (
  sort(runif(nfalse, 0, 0.05 / m)),
  sort(runif(m - nfalse, 0.1, 1))
)
kFWER_LocalTest (
  LocalTest = function (x) min(x) * length(x),
  pvals = pvals,
  k = 5,
  alpha = 0.05,
  verbose = FALSE
)
}
