% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestSet_LocalTest.R
\name{TestSet_LocalTest}
\alias{TestSet_LocalTest}
\alias{TestSet_localTest}
\title{Test a subset of hypotheses in its closure using a user-specified local test}
\usage{
TestSet_LocalTest(
  LocalTest,
  pvals,
  subset,
  alpha = 0.05,
  EarlyStop = FALSE,
  verbose = FALSE,
  mc.cores = 1L,
  chunksize = 4 * mc.cores,
  is.sorted = FALSE,
  ...
)

TestSet_localTest(
  localTest,
  pvals,
  subset,
  alpha = 0.05,
  EarlyStop = FALSE,
  verbose = FALSE,
  mc.cores = 1L,
  chunksize = 4 * mc.cores,
  is.sorted = FALSE,
  ...
)
}
\arguments{
\item{LocalTest}{Function which defines a combination test.}

\item{pvals}{Numeric vector of p-values.}

\item{subset}{Numeric vector; the subset to be tested.}

\item{alpha}{Numeric; the level to test at, if stopping early. Defaults
to 0.05.}

\item{EarlyStop}{Logical; set to TRUE to stop as soon as a hypothesis can be
accepted at level alpha. This speeds up the procedure, but now only provides
lower bounds on the p-values for the global test.}

\item{verbose}{Logical; set to TRUE to print progress.}

\item{mc.cores}{Number of cores to parallelize onto.}

\item{chunksize}{Integer indicating the size of chunks to parallelize. E.g.,
if setting chunksize = mc.cores, each time a parallel computation is set up,
each worker will perform only a single task. If mc.cores > chunksize, some
threads will be inactive.}

\item{is.sorted}{Logical, indicating whether the supplied p-values are already
is.sorted. Defaults to FALSE.}

\item{...}{Additional arguments.}

\item{localTest}{A function specifying a local test (deprecated).}
}
\value{
The adjusted p-value for the test of the hypothesis that there are
no false hypotheses among the selected subset.
}
\description{
Test a subset of hypotheses in its closure using a user-specified local test
}
\examples{
## Simulate p-values; 10 from false hypotheses, 10 from true
pvals = sort(c(
  rbeta(10, 1, 20), # Mean value of .1
  runif(10)
))
## Test whether the highest 10 contain any false hypotheses using a Bonferroni test
TestSet_LocalTest(function(x) {
  min(c(1, length(x) * min(x)))
}, pvals, subset = 11:20)
}
