% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestTFM.R
\name{ttest.TFM}
\alias{ttest.TFM}
\title{T-test for Truncated Factor Model}
\usage{
ttest.TFM(X, p, alpha = 0.05)
}
\arguments{
\item{X}{A matrix or data frame of simulated or observed data from a truncated factor model.}

\item{p}{The number of variables (columns) in the dataset.}

\item{alpha}{The significance level for the t-test.}
}
\value{
A list containing:
\item{FDR}{The False Discovery Rate calculated from the rejected hypotheses.}
\item{Power}{The power of the test, representing the proportion of true positives among the non-zero hypotheses.}
\item{pValues}{A numeric vector of p-values obtained from the t-tests for each variable.}
\item{RejectedHypotheses}{A logical vector indicating which hypotheses were rejected based on the specified significance level.}
}
\description{
This function performs a simple t-test for each variable in the dataset of a truncated factor model and calculates the False Discovery Rate (FDR) and power.
}
\examples{
library(MASS)
library(mvtnorm)
set.seed(100)
p <- 400 
n <- 120 
K <- 5   
true_non_zero <- 100
B <- matrix(rnorm(p * K), nrow = p, ncol = K)
FX <- MASS::mvrnorm(n, rep(0, K), diag(K))
U <- mvtnorm::rmvt(n, df = 3, sigma = diag(p))
mu <- c(rep(1, true_non_zero), rep(0, p - true_non_zero))
X <- rep(1, n) \%*\% t(mu) + FX \%*\% t(B) + U  # The observed data
results <- ttest.TFM(X, p, alpha = 0.05)
print(results)
}
