% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmEnvTMakeNew.r
\name{tdmEnvTReport}
\alias{tdmEnvTReport}
\title{Make a report plot based on \code{envT}}
\usage{
tdmEnvTReport(envT, ind)
}
\arguments{
\item{envT}{results from a prior tuning run.}

\item{ind}{an integer from \code{1:length(envT$bstGrid)}: Take the tuning run with index \code{ind}.}
}
\value{
\code{envT}, with data frame \code{finals} added, if  \code{envT$tdm$nrun > 0}.
}
\description{
Given the results from a prior tuning run in \code{envT}, make a sensitivity plot
for this run. \cr
If \code{envT$tdm$nrun > 0} then make additionally with the best-performing parameters from 
the tuning run a new unbiased run on the test data.
}
\examples{
           
   ## The best results are read from demo02sonar/demoSonar.RData relative to the TDMR 
   ## package directory.
   path = paste(find.package("TDMR"), "demo02sonar",sep="/");
   envT = tdmEnvTLoad("demoSonar.RData",path);    # loads envT
   source(paste(path,"main_sonar.r",sep="/"));
   envT$tdm$nrun=0;       # =0: don't, >0: do unbiasedRun with opts$NRUN=envT$tdm$nrun
   envT$sCList[[1]]$opts$VERBOSE=1;
   envT <- tdmEnvTReport(envT,1);
   if (!is.null(envT$theFinals)) print(envT$theFinals);

}
\seealso{
\code{\link{tdmEnvTReportSens}}
}
