% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_median22Y.R
\name{histmed22Y}
\alias{histmed22Y}
\title{Wasserstein Median of Histograms by You et al. (2022)}
\usage{
histmed22Y(hists, weights = NULL, lambda = NULL, ...)
}
\arguments{
\item{hists}{a length-\eqn{N} list of histograms (\code{"histogram"} object) of same breaks.}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise,
it should be a length-\eqn{N} vector of nonnegative weights.}

\item{lambda}{a regularization parameter; if \code{NULL} (default), a paper's suggestion
would be taken, or it should be a nonnegative real number.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{init.vec}{an initial weight vector (default: uniform weight).}
\item{maxiter}{maximum number of iterations (default: 496).}
\item{nthread}{number of threads for OpenMP run (default: 1).}
\item{print.progress}{a logical to show current iteration (default: \code{FALSE}).}
}}
}
\value{
a \code{"histogram"} object of the Wasserstein median histogram.
}
\description{
Given multiple histograms represented as \code{"histogram"} S3 objects, compute the
Wasserstein median of order 2. We need one requirement that all histograms in an
input list \code{hists} must have \bold{same breaks}. See the example on how to
construct a histogram on predefined breaks/bins.
}
\examples{
\donttest{
#----------------------------------------------------------------------
#                      Binned from Two Gaussians
#
# EXAMPLE : small example for CRAN for visualization purpose.
#----------------------------------------------------------------------
# GENERATE FROM TWO GAUSSIANS WITH DIFFERENT MEANS
set.seed(100)
x  = stats::rnorm(1000, mean=-4, sd=0.5)
y  = stats::rnorm(1000, mean=+4, sd=0.5)
bk = seq(from=-10, to=10, length.out=20)

# HISTOGRAMS WITH COMMON BREAKS
histxy = list()
histxy[[1]] = hist(x, breaks=bk, plot=FALSE)
histxy[[2]] = hist(y, breaks=bk, plot=FALSE)

# COMPUTE
hmean = histbary15B(histxy)
hmeds = histmed22Y(histxy)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
barplot(histxy[[1]]$density, col=rgb(0,0,1,1/4), 
        ylim=c(0, 1.05), main="Two Histograms")
barplot(histxy[[2]]$density, col=rgb(1,0,0,1/4), 
        ylim=c(0, 1.05), add=TRUE)
barplot(hmean$density, main="Barycenter",
        ylim=c(0, 1.05))
barplot(hmeds$density, main="Wasserstein Median",
        ylim=c(0, 1.05))
par(opar)
}

}
\concept{histogram}
