% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranefDiagnostics.R
\name{ranefDiagnostics}
\alias{ranefDiagnostics}
\title{Diagnostics of random effects of the linear mixed model}
\usage{
ranefDiagnostics(model, norm_test = "shapiroTest", verbose = TRUE)
}
\arguments{
\item{model}{An object of class "lme" or "nlme" representing the mixed-effects model fitted by \code{\link[=lmmModel]{lmmModel()}}.}

\item{norm_test}{String indicating the function for testing the normality of the random effects. A collection of functions from
\code{fBasics::\link[fBasics:normalTest]{normalTest}} is available. We recommend using one of "shapiroTest", "dagoTest",
or "adTest" for performing Shapiro - Wilk,
D'Agostino, or Anderson - Darling normality test, respectively.}

\item{verbose}{Logical indicating if the normality and homoscedasticity tests results should be printed to the console.}
}
\value{
A list with different elements for the diagnostics of the random effects are produced:
\itemize{
\item \code{plots}: Different plots for evaluating the normality and homoscedasticity of the random effects are produced.
\item \code{Normality}: Results from the test of the normality of the random effects.
\item \code{Levene.test}: results from Levene homoscedasticity test (\code{\link[car:leveneTest]{car::leveneTest()}}) of the normalized residuals by SampleID (i.e., by subject).
\item \code{Fligner.test}: results from Fligner homoscedasticity test (\code{\link[stats:fligner.test]{stats::fligner.test()}}) of the normalized residuals by SampleID (i.e., by subject).
}
}
\description{
\code{ranefDiagnostics} provides several plots as well as statistical test for the examination
of the normality of the random effects of the input model.
}
\details{
One of the assumptions of the model obtained with \code{\link[=lmmModel]{lmmModel()}} (as in any other linear mixed model) is that
the random effects are normally distributed:

\deqn{b_i = N(0,\psi)}

For the evaluation of this assumption, \code{ranefDiagnostics} provides Q-Q plots of random effects,
together with statistical assessment of their normality using Shapiro-Wilk, D'Agostini and Anderson-Darling normality tests.
Additionally, Q-Q plots of the normalized residuals
(standardized residuals pre-multiplied by the inverse square-root factor of the estimated error correlation matrix, see \link[nlme:residuals.lme]{nlme::residuals.lme})
by sample are provided to allow for the identification of subjects
which could be notably different from the others and be affecting the adequacy of the model.
Additionally, boxplots of the "raw" residuals (observed - fitted) by sample and scatter plots of the normalized residuals versus fitted values by sample
are provided to give information about variability of the residuals by subject and possible outlier observations. Observations with absolute standardized (normalized)
residuals greater than the \eqn{1-0.05/2} quantile of the standard normal distribution
are identified in the scatter plots labelled with the time point corresponding to the observation.
}
\examples{
# Load the example data
data(grwth_data)
# Fit the model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination"
  )
# Run random effects diagnostics
ranef_diag <- ranefDiagnostics(lmm)

#Access to individual plots

ranef_diag$Plots[1]
ranef_diag$Plots[2]

# Access to normality tests

ranef_diag$Normality

# Access to homoscedasticity tests of residuals by subject

ranef_diag$Levene.test

ranef_diag$Fligner.test

}
\references{
\itemize{
\item Pinheiro JC, Bates DM (2000). \emph{Mixed-Effects Models in S and S-PLUS}. Springer, New York. \doi{doi:10.1007/b98882}.
\item Andrzej Galecki & Tomasz Burzykowski (2013) \emph{Linear Mixed-Effects Models Using R: A Step-by-Step Approach} First Edition. Springer, New York. ISBN 978-1-4614-3899-1
}
}
\seealso{
\code{\link[=plot_ranefDiagnostics]{plot_ranefDiagnostics()}}
}
