% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swim_parse_ISL.R
\name{swim_parse_ISL}
\alias{swim_parse_ISL}
\alias{Swim_Parse_ISL}
\title{Formats swimming results from the International Swim League ('ISL') read with \code{read_results} into a dataframe}
\usage{
swim_parse_ISL(file)

Swim_Parse_ISL(file)
}
\arguments{
\item{file}{output from \code{read_results}}
}
\value{
returns a dataframe with columns \code{Place}, \code{Lane}, \code{Name}, \code{Team}, \code{Time}, \code{Points}, \code{Event} and \code{DQ}.
}
\description{
Takes the output of \code{read_results} and cleans it, yielding a dataframe of 'ISL' swimming results
}
\examples{
\dontrun{
swim_parse_ISL(
read_results(
"https://isl.global/wp-content/uploads/2019/11/isl_college_park_results_day_2.pdf"))
 }
}
\seealso{
\code{swim_parse_ISL} must be run on the output of \code{\link{read_results}}
}
\author{
Greg Pilgrim \email{gpilgrim2670@gmail.com}
}
