% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuessR_Package.R
\encoding{UTF-8}
\name{SuessR.custom}
\alias{SuessR.custom}
\title{Calculate Suess and Laws corrections for stable carbon isotope data from a custom region}
\usage{
SuessR.custom(data, custom.region.data, correct.to = 1850)
}
\arguments{
\item{data}{A dataframe including sample ID, year of sample collection, uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C
data, and region. This function is specifically for data from regions not
currently built into SuessR. Columns must be named 'id', 'year', 'd13c', and 'region'.}

\item{custom.region.data}{A data frame containing environmental data for the custom region from which the
samples originated. Must contain columns titled 'year', 'region', 'r', 'sst', 'sss', 'CO2atm', 'up.con', and 'Cp'.
See details for information on how to supply these parameters appropriately.}

\item{correct.to}{The year to which the \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data will be corrected. Defaults to 1850, pre-Suess effect.}
}
\value{
The output of this function is a data frame that includes the sample ID ('id'), year ('year'),
  uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C ('d13c.uncor'), Laws correction ('Laws.cor'), Suess Correction ('Suess.cor'), net correction
  ('net.cor'), and corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C ('d13c.cor') for each sample. The corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data is equal to the uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data
  plus the net correction. The units for all values are the standard 'per mil' used for \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data.
}
\description{
The SuessR.custom() function generates region-specific Suess, Laws, and net (Suess + Laws) corrections for
  \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data input by the user. The net correction is then used to calculate the corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data,
  which are supplied in the output. This function is specifically for data from regions not currently built into SuessR
  (i.e., different from "Bering", "Aleutians", "Gulf of Alaska", and "Subpolar North Atlantic", as of Version 0.1.2). Or
  for scenarios in which users want to change the default parameters used by SuessR for the built-in regions (e.g., averge phytoplankton cell radius).
}
\details{
The SuessR.custom() allows users to calculate and apply Suess and Laws corrections to \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data from marine
  organisms collected in a region not currently built into the SuessR package. In the initial release (Version 0.1.2), the
  built-in regions are the Bering Sea ('Bering'), the Aleutian archipelago ('Aleutians'), and the Gulf of Alaska ('Gulf of
  Alaska'). Because the Suess and Laws corrections require region-specific environmental data from 1850-present, users must
  supply these data using the 'custom.region.data' argument. Once these data have been supplied, this function calculates
  the corrections exactly like the SuessR() function. See the built-in 'SuessR.reference.data' object for an example
  template for the data, as well as the references for detailed information on how to compile and supply the appropriate
  data to the SuessR.custom() function. After compiling these data, please consider sharing them with the package authors
  (ctclark 'at' alaska.edu) to be included as built-in regions in future version of this package.

As with the SuessR() function, SuessR.custom() allows users to correct their data to a specific year, using the 'correct.to'
  argument. This argument defaults to AD1850, which represents onset of the Industrial Revolution and the initiation of the
  large-scale combusion of fossil fuels that created the Suess Effect. Correcting data to 1850 allows them to be compared to
  data from any samples collected during or before 1850 (including archaeological samples), as well as to any other samples
  Suess corrected to the year 1850. Users examining contemporary datasets may wish to correct their data to another time year.
  For example, a user examining a dataset of \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data spanning the years 1970-2010 might choose to correct all their data back
  to the year 1970, to correct the older samples forward to 2010, or to correct all the samples to 1990, the middle of the time
  series. In any of these scenarios, corrected data would be comparable to one another. When choosing a value for 'correct.to'
  consideration should be given to the comparability of the user's data to existing data sets, clarity of presentation of
  results (i.e., clear statements of the year to which the data were corrected), and reproducibility of results (i.e.,
  presentation of both uncorrected and corrected data so future users can repeat analyses or correct the raw data to another year).
}
\examples{
example.region.data <- data.frame(year = seq(from = 1850, to = 2020, by = 1),
                                  region = rep("Example Region", 171),
                                  r = rep(5, 171),
                                  sst = seq(5.9, 6.6, 171),
                                  sss = seq(32.3, 32.7, 171),
                                  CO2atm = SuessR.reference.data$CO2atm,
                                  up.con = rep(0.014, 171),
                                  Cp = rep(0.41, 171))

example.custom.data <- data.frame(id = c("Sample 1", "Sample 2",
                                         "Sample 3", "Sample 4"),
                                  year = c(1850, 1900, 1950, 2000),
                                  d13c = c(-12, -12, -12, -12),
                                  region = rep("Example Region", 4))

SuessR.custom(data = example.custom.data,
              custom.region.data = example.region.data,
              correct.to = 1850)

}
