% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilines.R
\name{multilines}
\alias{multilines}
\title{Draws several lines}
\usage{
multilines(i, x, y, j = unique(i), forget = NULL, front = NULL,
  back = NULL, type = "l", col = "black", bg = NA, pch = 19,
  lty = par("lty"), lwd = par("lwd"), cex = par("cex"), lend = 0,
  ljoin = 0, lmitre = 10)
}
\arguments{
\item{i}{a  line id for each x and y coordinate, i.e. the name of
each polyline. If you want to give each line a different aspect you should
provide a vector of n elements (if you have three lines "A1", "A2" and
"A3" with "A2" that should be blue you should provide the colours of all
three: e.g. \code{col = c("white", "blue", "white")})}

\item{x, y}{numeric vectors of x and y coordinates}

\item{j}{a list of the ids (names) in the order used for the
graphical parameters (e.g. colour, shading, etc...). By default they are in
their order of appearance in \code{i}}

\item{forget}{the lines that should not be drawn, by their id or
index (i.e. name or number of appearance).}

\item{front, back}{the lines to be put in front and back position,
by their id or index (i.e. name or number of appearance). By default the
order is the one defined by \code{j}, and if \code{j} is absent by the order
in \code{i}.}

\item{type}{character indicating the type of plotting. For this
function it is limited to "l" (lines, is the default), "p" (points) and "o"
(points overplotting lines).}

\item{col}{the color to draw the line. The default is black.}

\item{bg}{background (fill) color for the open plot symbols given by
pch = 21:25.}

\item{pch}{plotting ‘character’, i.e., symbol to use. See ?points for
further details}

\item{lty, lwd}{the line type and width, see ?par for details.}

\item{cex}{haracter (or symbol) expansion: a numerical vector. This
works as a multiple of par("cex")}

\item{lend, ljoin, lmitre}{additional graphical parameters, see ?par
for details.}
}
\description{
Draws several polylines or group of points. This function
expands on the lines() and points functions from base R graphics. The
difference is that several lines and group of points can
be drawn in one line by providing an id: i. To each line and group of point
you can provide different graphical parameters (i.e. colour, type, etc).
}
\examples{
i <- c(rep("A1",6), rep("A2",6), rep("A3",6))
x <- c(1,2,3,3,2,1,4,5,6,6,5,4,7,8,9,9,8,7)
y <- c(1,2,3,4,5,6,1,2,3,4,5,6,1,2,3,4,5,6)

plot(c(0,10),c(0,7),type = "n")

multilines(i, x, y, j = c("A3", "A1", "A2"), lty =  c(1,2,3), lwd = 2,
           type = c("l", "o", "o"), pch = c(NA,21,24), cex = 2)

}
\seealso{
\code{\link{multigons}}

Complementary function: \code{\link{shift}}

Uses \code{\link{ignore}} to avoid drawing unnecessary objects
}
