% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earplanes.R
\name{earplanes}
\alias{earplanes}
\title{Draws planes on an equal area stereonet}
\usage{
earplanes(strike, dip, quadrant = NA, hsphere = "l", ndiv = 10,
  a = list(col = "black", lwd = 1), l = list(lty = 1), u = list(lty = 3),
  output = FALSE, plot = TRUE, xh = "WE", unique = TRUE)
}
\arguments{
\item{strike}{strike of the data; it is the angle from the north of
the horizontal line of the plane. It is corrected by the \code{\link{dipfix}}
function.}

\item{dip}{dip of the data; it is the angle from the horizontal taken
on the line of the plane perpendicular to the one of the strike. It is
corrected by the \code{\link{dipfix}} function.}

\item{quadrant}{the quadrant were the plane dips downward. Accepted
values are NA, 'N', 'S', 'W' or 'E' (lower- or uppercase alike) for
correction by the \code{\link{dipfix}} function.}

\item{hsphere}{the hemisphere onto which to project the data. Either
"b" for both, "l" for lower, and u" for upper.}

\item{ndiv}{the number of intervals between each 10° (in declination)}

\item{a, l, u}{list of graphical parameters to feed lines() for the all
lines, or for the lines of the upper (u) and lower (l) hemisphere (the two
latter override a). See ?lines help page for the possible arguments. See
?merge_list for further information.}

\item{output}{whether to return an output (position of the points
making the lines in the stereographic projection)}

\item{plot}{whether to plot}

\item{xh}{orientation of the x axis: can be 'WE' or 'SN'.}

\item{unique}{whether to only plot each similar plan once.}
}
\value{
the x,y coordinates of each projected plane
}
\description{
Draws planes on an equal area stereonet (modified from RFOC
package)
}
\examples{
strike   <- c(45,  0)
dip      <- c(20, 65)

earnet()
earplanes(strike,dip,hsphere = "b")

encircle(earinc(dip))

}
\references{
RFOC package
}
\seealso{
\code{\link{earnet}}, \code{\link{earpoints}} and
\code{\link{dipfix}}
}
