% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ssa.R
\name{ssa}
\alias{ssa}
\title{Gillespie Stochastic Simulation Algorithm}
\usage{
ssa(modelFile, outputDir, time, realizations, intervals = 0,
  noStats = FALSE, keepTrajectories = FALSE, keepHistograms = FALSE,
  bins = 32, force = FALSE, seed = NULL, p = 0)
}
\arguments{
\item{modelFile}{Character string with path to StochKit2 .xml model file}

\item{outputDir}{Character string with path to output directory. If output directory does not exist, it will be created. If output directory already exists, use \code{force=TRUE} to overwrite}

\item{time}{Simulation time of each realization}

\item{realizations}{Number of realizations}

\item{intervals}{Number of output intervals. Default 0 outputs at end time only. 1=keep data at start and end time, 2=keep data at start, middle, and end times, etc. Note data is stored at (intervals+1) equally spaced time points.}

\item{noStats}{Do not keep means and variances data. Default \code{FALSE} creates stats directory in output directory}

\item{keepTrajectories}{Keep trajectory data. Creates trajectories directory in output directory}

\item{keepHistograms}{Keep histogram data. Creates histograms directory in output directory}

\item{bins}{Number of histogram bins}

\item{force}{Force overwriting of existing data}

\item{seed}{Seed the random number generator. By default the seed is determined by the R random number generator, so the seed can also be set by calling \code{set.seed} in R immediately before calling \code{ssa}}

\item{p}{Override default and specify the number of processes (threads) to use. By default (=0), the number of processes will be determined automatically (recommended). Ignored on systems without OpenMP support.}
}
\description{
\code{ssa} Runs an ensemble of SSA \code{realizations} and writes output
data to \code{outputDir}
}
\examples{
\dontrun{
#'#example using included dimer_decay.xml file
#output written to directory ex_out (created in current working directory)
#run 100 simulations for 10 time units, keeping output at 20 time intervals
#store model file name in a variable first
model <- system.file("dimer_decay.xml",package="StochKit2R")
ssa(model,"ex_out",10,100,20,force=TRUE)

#more typical example where model file is stored elsewhere
#(must be valid path to existing .xml StochKit2 model file)
#store output in dimer_decay_output, overwrite existing data
#and keep trajectory data.
ssa("Desktop/dimer_decay.xml",
   "Desktop/dimer_decay_output",10,100,20,keepTrajectories=T,force=T)
}
}

