% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_varmod.R
\name{gen_varmod}
\alias{gen_varmod}
\title{Generating a var.mod type file}
\usage{
gen_varmod(
  workspace,
  var,
  append = FALSE,
  file_name = "var.mod",
  stics_version = "latest",
  force = FALSE,
  var_names = lifecycle::deprecated(),
  version = lifecycle::deprecated()
)
}
\arguments{
\item{workspace}{Path of the directory containing the STICS var.mod file
to modify}

\item{var}{vector of variables names (see details)}

\item{append}{if TRUE, \code{var} data are appended to \code{file_name}}

\item{file_name}{file name to generate
(without path, default value: "var.mod")}

\item{stics_version}{Name of the STICS version
(used to check variable names)}

\item{force}{Force variables writing even if they are not a
STICS variable (default: FALSE).}

\item{var_names}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{var_names} is no
longer supported, use \code{var} instead.}

\item{version}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version} is no
longer supported, use \code{stics_version} instead.}
}
\value{
None
}
\description{
Generating a daily variable list file from variables names
}
\details{
Variable names can be found using \code{get_var_info()}. They are
checked before writing. If any variable name does not exist,
it will not be written by default, but the function will still write
the variables that exist. \code{force= TRUE} may however be used to write
variables that do not exist.
}
\examples{
gen_varmod(tempdir(), c("lai(n)", "hauteur"))
# Add a variable to the others:
gen_varmod(tempdir(), "masec(n)", append = TRUE)
# NB: var.mod will have "lai(n)","hauteur" and "masec(n)"


}
