% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_functions.R
\name{sim.data.calculate.posteriors}
\alias{sim.data.calculate.posteriors}
\title{Simulate data from priors then use to calculate posterior probability of models given data}
\usage{
sim.data.calculate.posteriors(fit.smry, data, analysis.name, coes.prior,
  sig.prior, d.range, d.adj.max, wts, n.samps.per.mod, min.R2,
  print.interval = NA, outdir = tempdir())
}
\arguments{
\item{fit.smry}{\code{fit.smry} contains the R^2 and P values for all models and is generated in \code{\link{fit.models}}}

\item{data}{Dataset to fit}

\item{analysis.name}{Make up some unique name. Simulate data is saved into inst directory}

\item{coes.prior}{A vector with the lower and upper bounds on the coefficients}

\item{sig.prior}{A vector with the lower and upper bound on sigma}

\item{d.range}{Interval of d to search for maximum over}

\item{d.adj.max}{Factor to increase observed distant to max fitness by for ad hoc d estimate (when other estimators fail)}

\item{wts}{Weights when estimating coefficients and d.}

\item{n.samps.per.mod}{The number of datasets to simulate per model}

\item{min.R2}{Minimum R^2 value. Suggest -1.}

\item{print.interval}{Outputs progress of simulation.}

\item{outdir}{Specify a directory for outputting results and temporary files. default=tempdir()}
}
\value{
List:\cr
\code{$posteriors} Posterior probability of each epistasis model. \cr
\code{$multinomial.model} Multinomial model fit to the simulated data used to assign posterior probabilities.
}
\description{
Simulate data from priors then use to calculate posterior probability of models given data
}
\examples{
\dontrun{
fit.results <- fit.models(Chou.data, c(0.1, 10), 1.1, c(2,1))
sim.data.calculate.posteriors(fit.results$fit.smry,
                           Chou.data,
                           "Test",
                           c(0.05, 0.5),
                           c(0, 0.25),
                           c(0.1, 10),
                           1.1,
                           c(2,1),
                           50,
                           -1,25,
                           outdir="~/Desktop")
 }
}

