% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_r.cat.R
\name{p_r.cat}
\alias{p_r.cat}
\title{p-value from tetrachoric/polychoric or polyserial}
\usage{
p_r.cat(
  n,
  r,
  tauX,
  rho = 0,
  tauY = NULL,
  ML = TRUE,
  two.tailed = TRUE,
  score = FALSE,
  gen_fun = gen_r,
  return_analysis = FALSE,
  ...
)
}
\arguments{
\item{n}{sample size}

\item{r}{correlation prior to the discretization (recovered via the
polyserial/polychoric estimates)}

\item{tauX}{intercept parameters used for discretizing the X variable}

\item{rho}{population coefficient to test against}

\item{tauY}{intercept parameters used for discretizing the Y variable. If
missing a polyserial correlation will be estimated, otherwise a
tetrachoric/polychoric correlation will be estimated}

\item{ML}{logical; use maximum-likelihood estimation?}

\item{two.tailed}{logical; should a two-tailed or one-tailed test be used?}

\item{score}{logical; should the SE be based at the null hypothesis (score test)
or the ML estimate (Wald test)? The former is the canonical form for
a priori power analyses though requires twice as many computations as the
Wald test approach}

\item{gen_fun}{function used to generate the required
continuous bivariate data (prior to truncation).
Object returned must be a \code{matrix} with two columns.
Default uses \code{\link{gen_r}} to generate conditionally
dependent data from a bivariate normal distribution.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates correlated X-Y data and returns a p-value to assess the null
of no correlation in the population. The X-Y data are generated
assuming a multivariate normal distribution and subsequently discretized
for one or both of the variables.
}
\examples{

# 100 observations, .5 correlation, tetrachoric estimate
p_r.cat(100, r=.5, tauX=0, tauY=1)

# return analysis model
p_r.cat(100, r=.5, tauX=0, tauY=1, return_analysis=TRUE)

# Wald test
p_r.cat(100, r=.5, tauX=0, tauY=1, score=FALSE)

# polyserial estimate (Y continuous)
p_r.cat(50, r=.5, tauX=0)

}
\seealso{
\code{\link{gen_r}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
