% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.R
\name{sk.decompose}
\alias{sk.decompose}
\title{make SVD as well as orthogonal complements}
\usage{
sk.decompose(X, D)
}
\arguments{
\item{X}{the input matrix}

\item{D}{the linear transformer}
}
\value{
U

S

V

U_perp : orthogonal complement for U
}
\description{
make SVD as well as orthogonal complements
}
\examples{
library(mvtnorm)
n = 350
p = 100
m = 200
Sigma = matrix(0, p, p)
D <- matrix(0,m,p)
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
decompose.result <- sk.decompose(X,D)
U_perp <- decompose.result$U_perp
}
