% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{splitknockoff.filter}
\alias{splitknockoff.filter}
\title{splitknockoff.filter}
\usage{
splitknockoff.filter(X, D, y, option)
}
\arguments{
\item{X}{the design matrix}

\item{D}{the linear transform}

\item{y}{the response vector}

\item{option}{options for creating the Knockoff statistics
option$eta: the choice of eta for creating the knockoff copy
option$q: the desired FDR control bound
option$method: 'knockoff' or 'knockoff+'
option$stage0: choose the method to conduct split knockoff.
      'fixed': fixed intercept assignment for PATH ORDER method.
         option$beta : the choice of fixed beta for step 0:
              'mle': maximum likelihood estimator.
              'ridge': ridge regression choice beta with lambda = 1/nu.
              'cv_split': cross validation choice of split LASSO over nu
              and lambda.
              'cv_ridge': cross validation choice of ridge regression
              over lambda.
      'path': take the regularization path of split LASSO as the intercept
              assignment for PATH ORDER method.
      'magnitude': using MAGNITUDE method.
option$lambda: a set of lambda appointed for path calculation
option$nu: a set of nu used for Split Knockoffs
option$normalize: whether to normalize the data}
}
\value{
results: a cell with the selected variable set in each cell w.r.t. nu.

Z: a cell with the feature significance Z in each cell w.r.t. nu.

t_Z: a cell with the knockoff significance tilde_Z in each cell w.r.t. nu.
}
\description{
Split Knockoff filter for structural sparsity problem.
}
\examples{
k <- 20   # sparsity level
A <- 1    # magnitude
n <- 350  # sample size
p <- 100  # dimension of variables
c <- 0.5  # feature correlation
sigma <-1 # noise level
option <- array(data = NA, dim = length(data), dimnames = NULL)
option$q <- 0.2
option$eta <- 0.1
option$method <- 'knockoff'
option$stage0 <- 'path'
option$normalize <- 'true'
option$cv_rule <- 'min'
option$lambda <- 10.^seq(0, -6, by=-0.01)
option$nu <- 10
option$copy <- 'true'
option <- option[-1]
# generate D
D <- diag(p)
m <- nrow(D)
# generate X
Sigma = matrix(0, p, p)
for( i in 1: p){
  for(j in 1: p){
    Sigma[i, j] <- c^(abs(i - j))
  }
}
library(mvtnorm)
set.seed(100)
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
# generate beta and gamma
beta_true <- matrix(0, p, 1)
for( i in 1: k){
  beta_true[i, 1] = A
  if ( i\%\%3 == 1){
    beta_true[i, 1] = -A
  }
}
gamma_true <- D \%*\% beta_true
S0 <- which(gamma_true!=0)
# generate varepsilon
set.seed(1)
# generate noise and y
varepsilon <- rnorm(n) * sqrt(sigma)
y <- X \%*\% beta_true + varepsilon
filter_result <- splitknockoff.filter(X, D, y, option)
Z_path <- filter_result$Z
t_Z_path <- filter_result$t_Z
}
