% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_directional_spillover.R
\name{plotdy}
\alias{plotdy}
\title{Plot directional spillover index}
\usage{
plotdy(
  data,
  direction = c("from", "to", "net", "net_pairwise", "from_to_pairwise")
)
}
\arguments{
\item{data}{An object class \code{directional.spillover} resulting from applying \code{dynamic.spillover}}

\item{direction}{A character string indicating the direction of the spillover, see Diebold and Yilmaz (2012)}
}
\value{
a ggplot2 object consisting of directional plots
}
\description{
Plot directional spillover index
}
\examples{
\donttest{ 
library(Spillover)
require(tidyr)
require(dplyr)
require(ggplot2)

data(dy2012)
dy_results <- dynamic.spillover(data=dy2012, width=200, remove.own = FALSE) 

pp_from <- plotdy(dy_results, direction = "from")

pp_from +
 labs(title="Any title") +
 facet_wrap(~variables, ncol = 2)

pp_to <- plotdy(dy_results, direction = "to")

pp_net <- plotdy(dy_results, direction = "net")

pp_netpairwise <- plotdy(dy_results, direction = "net_pairwise")

pp_from_to_pairwise <- plotdy(dy_results, direction = "from_to_pairwise")



}

}
\references{
Diebold, F. X. & Yilmaz, K.(2012). \emph{Better to Give than to Receive: Predictive Directional Measurement of Volatility Spillovers}. International Journal of Forecasting.
}
