% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stewart.R
\name{plotStewart}
\alias{plotStewart}
\title{Plot a Stewart Raster}
\usage{
plotStewart(
  x,
  add = FALSE,
  breaks = NULL,
  typec = "equal",
  nclass = 5,
  legend.rnd = 0,
  col = colorRampPalette(c("#FEA3A3", "#980000"))
)
}
\arguments{
\item{x}{raster; output of the \code{\link{rasterStewart}} function.}

\item{add}{logical; if TRUE the raster is added to the current plot, if FALSE 
the raster is displayed in a new plot.}

\item{breaks}{numeric; vector of break values to map. If used, 
this parameter overrides \code{typec} and \code{nclass} parameters}

\item{typec}{character; either "equal" or "quantile", how to discretize the values.}

\item{nclass}{numeric (integer), number of classes.}

\item{legend.rnd}{numeric (integer); number of digits used to round the values 
displayed in the legend.}

\item{col}{function; color ramp function, such as \code{\link{colorRampPalette}}.}
}
\value{
Display the raster nicely and return the list of break values (invisible).
}
\description{
This function plots the raster produced by the 
\code{\link{rasterStewart}} function.
}
\examples{
data(hospital)
# Compute Stewart potentials from known points (hospital) on a
# grid defined by its resolution
mystewart <- stewart(knownpts = hospital, varname = "capacity",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 100, mask = paris)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart, mask = paris)
# Plot stewart potentials nicely
plotStewart(x = mystewartraster, add = FALSE, nclass = 5)
# Can be used to obtain break values
break.values <- plotStewart(x = mystewartraster, add = FALSE, nclass = 5)
break.values
}
\seealso{
\link{stewart}, \link{rasterStewart}, \link{quickStewart}, 
\link{rasterToContourPoly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}
