% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnnModel.R
\name{deconvSpatialDDLS}
\alias{deconvSpatialDDLS}
\title{Deconvolute spatial transcriptomics data}
\usage{
deconvSpatialDDLS(
  object,
  index.st,
  normalize = TRUE,
  scaling = "rescale",
  simplify.set = NULL,
  simplify.majority = NULL,
  use.generator = FALSE,
  batch.size = 64,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{trained.model} and \code{spatial.experiments} slots.}

\item{index.st}{Name or index of the dataset/slide stored in the
\code{SpatialDDLS} object (\code{spatial.experiments} slot) to be
deconvolute. If missing, all datasets will be deconvoluted.}

\item{normalize}{Normalize data before deconvolution (\code{TRUE} by
default).}

\item{scaling}{How to scale data before training. It may be:
\code{"standarize"} (values are centered around the mean with a unit
standard deviation) or \code{"rescale"} (values are shifted and rescaled so
that they end up ranging between 0 and 1). If \code{normalize = FALSE},
data are not scaled.}

\item{simplify.set}{List specifying which cell types should be compressed
into a new label with the name of the list item. See examples for details.
If provided, results are stored in a list with \code{'raw'} and
\code{'simpli.set'} elements.}

\item{simplify.majority}{List specifying which cell types should be
compressed into the cell type with the highest proportion in each spot.
Unlike \code{simplify.set}, no new labels are created. If provided, results
are stored in a list with \code{'raw'} and \code{'simpli.majority'}
elements.}

\item{use.generator}{Boolean indicating whether to use generators for
prediction (\code{FALSE} by default).}

\item{batch.size}{Number of samples per batch. Only when \code{use.generator
= TRUE}.}

\item{verbose}{Show informative messages during the execution.}
}
\value{
\code{\linkS4class{SpatialDDLS}} object with a \code{deconv.spots}
slot. The output is a data frame with spot (\eqn{i}) as rows and cell types
(\eqn{j}) as columns. Each entry represents the predicted proportion of
\eqn{j} cell type in \eqn{i} spot. If \code{simplify.set} and/or
\code{simplify.majority} are provided, the \code{deconv.spots} slot will
contain a list with raw and simplified results.
}
\description{
Deconvolute spatial transcriptomics data using the trained model contained in
the \code{\linkS4class{SpatialDDLS}} object.
}
\details{
This function requires a \code{\linkS4class{SpatialDDLS}} object with a
trained deep neural network model (\code{\link{trained.model}} slot, and the
spatial transcriptomics datasets to be deconvoluted in the
\code{spatial.experiments} slot. See \code{?\link{createSpatialDDLSobject}}
or \code{?\link{loadSTProfiles}} for more details.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
     rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
 num.sim.spots = 50,
  verbose = TRUE
) 
SDDLS <- simMixedProfiles(SDDLS)
# training of SDDLS model
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 15,
  num.epochs = 5
)
# simulating mixed profiles
ngenes <- sample(3:40, size = 1)
ncells <- sample(3:40, size = 1)
counts <- matrix(
  rpois(ngenes * ncells, lambda = 5), ncol = ncells,
  dimnames = list(paste0("Gene", seq(ngenes)), paste0("Spot", seq(ncells)))
)
coordinates <- matrix(
  rep(c(1, 2), ncells), ncol = 2
)
st <- SpatialExperiment::SpatialExperiment(
  assays = list(counts = as.matrix(counts)),
  rowData = data.frame(Gene_ID = paste0("Gene", seq(ngenes))),
  colData = data.frame(Cell_ID = paste0("Spot", seq(ncells))),
  spatialCoords = coordinates
)
SDDLS <- loadSTProfiles(
  object = SDDLS,
  st.data = st,
  st.spot.ID.column = "Cell_ID",
  st.gene.ID.column = "Gene_ID"
)
# simplify arguments
simplify <- list(CellGroup1 = c("CellType1", "CellType2", "CellType4"),
                 CellGroup2 = c("CellType3", "CellType5"))
SDDLS <- deconvSpatialDDLS(
  object = SDDLS,
  index.st = 1,
  simplify.set = simplify,
  simplify.majority = simplify
)
}
  
}
\seealso{
\code{\link{trainDeconvModel}} \code{\linkS4class{SpatialDDLS}}
}
