% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Data Simulator}
\usage{
sim_data(genes, cells, sig.genes, sig.genes.s, clus.t1, clus.t2,
  same.sig = FALSE, u.l = 1, u.h = 2)
}
\arguments{
\item{genes}{The number of genes to be simulated.}

\item{cells}{The number of cells to be simulated per condition.}

\item{sig.genes}{The number of marker genes for each cluster.}

\item{sig.genes.s}{The number of marker genes shared across conditions for
each cluster. Should be less than or equal to \code{sig.genes}}

\item{clus.t1}{A vector of clusters present in the first condition. Start
at 1, e.g. \code{c(1,2,3,4)}}

\item{clus.t2}{A vector of clusters present in the second condition. Does
not have to match clus.t1, e.g \code{c(3,4,5)}}

\item{same.sig}{TRUE or FALSE. Should each cluster have a unique set of
marker genes. default is FALSE.}

\item{u.l}{Lower bound for the cluster gene means, default is 1.}

\item{u.h}{Upper bound for the cluster gene means, default is 2.}
}
\value{
A list containing the two simulated data matrices, \code{dat.1} and
\code{dat.2}, true clusters for the cells in the first and second
conditions, \code{clusters1} and \code{clusters2}, a matrix indicating
marker genes for the first and second condition, \code{sig.gene.mat.1}
and \code{sig.gene.mat.2}, the base mean values for each gene
\code{gene.means} and the cluster specific additions for each gene
\code{clus.gene.means}
}
\description{
Simulates two condition data for a range of conditions depending on the
parameters used.
}
\examples{
set.seed(10)
genes <- 1000  # Simulate 1,000 genes
cells <- 100  # Simulate 100 cells per condition
clus.t1 <- c(1,2,3)  # Generate 3 clusters present in condition A
clus.t2 <- c(1,2,3)  # Generate 3 clusters present in condition B
sig.genes <- 30  # Generate 30 marker genes per cluster
sig.genes.s <- 15  # Let half of the 30 marker genes be shared.
temp_sim_dat <- sim_data(genes, cells, sig.genes, sig.genes.s,
clus.t1, clus.t2)

}
