% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ridge_HJBiplot.R
\name{Ridge_HJBiplot}
\alias{Ridge_HJBiplot}
\title{Ridge HJ Biplot}
\usage{
Ridge_HJBiplot (X, Lambda, Transform.Data = 'scale')
}
\arguments{
\item{X}{array_like; \cr
A data frame which provides the data to be analyzed. All the variables must be numeric.}

\item{Lambda}{float; \cr
Tuning parameter for the Ridge penalty}

\item{Transform.Data}{character; \cr
A value indicating whether the columns of X (variables) should be centered or scaled. Options are: "center" that removes the columns means and "scale" that removes the columns means and divide by its standard deviation. Default is "scale".}
}
\value{
\code{Ridge_HJBiplot} returns a list containing the following components:
\item{eigenvalues}{  array_like; \cr
          vector with the eigenvalues penalized.
          }

\item{explvar}{  array_like; \cr
          an vector containing the proportion of variance explained by the first 1, 2,.,k sparse principal components obtained.
          }

\item{loadings}{  array_like; \cr
          penalized loadings, the loadings of the sparse principal components.
          }

\item{coord_ind}{  array_like; \cr
          matrix with the coordinates of individuals.
          }

\item{coord_var}{  array_like; \cr
          matrix with the coordinates of variables.
          }
}
\description{
This function performs the representation of the HJ Biplot applying the Ridge regularization, on the original data matrix, implementing the norm L2.
}
\details{
Algorithm used to contract the loads of the main components towards zero, but without achieving the nullity of any. If the penalty parameter is less than or equal to 1e-4 the result is like Galindo's HJ Biplot (1986).
}
\examples{
 Ridge_HJBiplot(mtcars, Lambda = 0.2)

}
\references{
\itemize{
 \item Galindo, M. P. (1986). Una alternativa de representacion simultanea: HJ-Biplot. Questiio, 10(1), 13-23.
 \item Hoerl, A. E., & Kennard, R. W. (1970). Ridge regression: Biased estimation for nonorthogonal problems. Technometrics, 12(1), 55-67.
 \item Zou, H., Hastie, T., & Tibshirani, R. (2006). Sparse principal component analysis. Journal of computational and graphical statistics, 15(2), 265-286.
}
}
\seealso{
\code{\link{Plot_Biplot}}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres-Cubilla, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
