% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{randomSplit}
\alias{randomSplit}
\alias{randomSplit}
\alias{randomSplit,SparkDataFrame,numeric-method}
\title{randomSplit}
\usage{
randomSplit(x, weights, seed)

\S4method{randomSplit}{SparkDataFrame,numeric}(x, weights, seed)
}
\arguments{
\item{x}{A SparkDataFrame}

\item{weights}{A vector of weights for splits, will be normalized if they don't sum to 1}

\item{seed}{A seed to use for random split}
}
\description{
Return a list of randomly split dataframes with the provided weights.
}
\note{
randomSplit since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
df <- createDataFrame(data.frame(id = 1:1000))
df_list <- randomSplit(df, c(2, 3, 5), 0)
# df_list contains 3 SparkDataFrames with each having about 200, 300 and 500 rows respectively
sapply(df_list, count)
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapplyCollect}}, \code{\link{dapply}},
  \code{\link{describe}}, \code{\link{dim}},
  \code{\link{distinct}}, \code{\link{dropDuplicates}},
  \code{\link{dropna}}, \code{\link{drop}},
  \code{\link{dtypes}}, \code{\link{except}},
  \code{\link{explain}}, \code{\link{filter}},
  \code{\link{first}}, \code{\link{gapplyCollect}},
  \code{\link{gapply}}, \code{\link{getNumPartitions}},
  \code{\link{group_by}}, \code{\link{head}},
  \code{\link{hint}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{isStreaming}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{localCheckpoint}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{rbind}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{rollup}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{summary}}, \code{\link{take}},
  \code{\link{toJSON}}, \code{\link{unionByName}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{withWatermark}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.stream}}, \code{\link{write.text}}
}
