% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{row_number}
\alias{row_number}
\alias{row_number}
\alias{row_number,missing-method}
\title{row_number}
\usage{
row_number(x = "missing")

\S4method{row_number}{missing}()
}
\arguments{
\item{x}{empty. Should be used with no argument.}
}
\description{
Window function: returns a sequential number starting at 1 within a window partition.
}
\details{
This is equivalent to the ROW_NUMBER function in SQL.
}
\note{
row_number since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)
  ws <- orderBy(windowPartitionBy("am"), "hp")
  out <- select(df, over(row_number(), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lag}},
  \code{\link{lead}}, \code{\link{ntile}},
  \code{\link{percent_rank}}, \code{\link{rank}}
}
