% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{lead}
\alias{lead}
\alias{lead}
\alias{lead,characterOrColumn,numeric-method}
\title{lead}
\usage{
lead(x, offset, defaultValue = NULL)

\S4method{lead}{characterOrColumn,numeric}(x, offset = 1,
  defaultValue = NULL)
}
\arguments{
\item{x}{the column as a character string or a Column to compute on.}

\item{offset}{the number of rows after the current row from which to obtain a value.
If not specified, the default is 1.}

\item{defaultValue}{(optional) default to use when the offset row does not exist.}
}
\description{
Window function: returns the value that is \code{offset} rows after the current row, and
\code{defaultValue} if there is less than \code{offset} rows after the current row.
For example, an \code{offset} of one will return the next row at any given point
in the window partition.
}
\details{
This is equivalent to the \code{LEAD} function in SQL.
}
\note{
lead since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)

  # Partition by am (transmission) and order by hp (horsepower)
  ws <- orderBy(windowPartitionBy("am"), "hp")

  # Lead mpg values by 1 row on the partition-and-ordered table
  out <- select(df, over(lead(df$mpg), ws), df$mpg, df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lag}},
  \code{\link{ntile}}, \code{\link{percent_rank}},
  \code{\link{rank}}, \code{\link{row_number}}
}
