% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R
\docType{methods}
\name{makeDigestible}
\alias{makeDigestible}
\alias{makeDigestible,simList-method}
\title{Remove any reference to environments in a \code{simList}}
\usage{
makeDigestible(simList)

\S4method{makeDigestible}{simList}(simList)
}
\arguments{
\item{simList}{an object of class \code{simList}}
}
\value{
A simplified version of the \code{simList} object, but with no
        reference to any environments
}
\description{
Internal use only. Used when caching a SpaDES run a \code{simList}.
}
\details{
This is a derivative of the class \code{simList}, except that all references
to local environments are removed.
Specifically, all functions (which are contained within environments) are
converted to a text representation via a call to \code{format(fn)}.
Also the objects that were contained within the \code{.envir} slot are hashed
using \code{digest::digest}.
The \code{paths} slot is not used (to allow comparison across platforms); it's
not relevant where the objects are gotten from, so long as they are the same.
The \code{.envir} slot is emptied (\code{NULL}).
The object is then converted to a \code{simList_} which has a \code{.list} slot.
The hashes of the objects are then placed in that \code{.list} slot.
}
\author{
Eliot McIntire
}
\seealso{
\code{\link[archivist]{cache}}.

\code{\link[digest]{digest}}.
}

