% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{methods}
\name{simInit}
\alias{simInit}
\alias{simInit,ANY,ANY,ANY,ANY,ANY,ANY,ANY,ANY-method}
\alias{simInit,ANY,ANY,ANY,character,ANY,ANY,ANY,ANY-method}
\alias{simInit,ANY,ANY,character,ANY,ANY,ANY,ANY,ANY-method}
\alias{simInit,list,list,list,list,list,data.frame,data.frame,character-method}
\title{Initialize a new simulation}
\usage{
simInit(times, params, modules, objects, paths, inputs, outputs, loadOrder)


  \S4method{simInit}{list,list,list,list,list,data.frame,data.frame,character}(times,
  params, modules, objects, paths, inputs, outputs, loadOrder)

\S4method{simInit}{ANY,ANY,ANY,character,ANY,ANY,ANY,ANY}(times, params,
  modules, objects, paths, inputs, outputs, loadOrder)

\S4method{simInit}{ANY,ANY,character,ANY,ANY,ANY,ANY,ANY}(times, params,
  modules, objects, paths, inputs, outputs, loadOrder)

\S4method{simInit}{ANY,ANY,ANY,ANY,ANY,ANY,ANY,ANY}(times, params, modules,
  objects, paths, inputs, outputs, loadOrder)
}
\arguments{
\item{times}{A named list of numeric simulation start and end times
(e.g., \code{times = list(start = 0.0, end = 10.0)}).}

\item{params}{A named list of simulation parameters and their values.}

\item{modules}{A named list of character strings specfying the names
of modules to be loaded for the simulation. Note: the module name
should correspond to the R source file from which the module is loaded.
Example: a module named "caribou" will be sourced form the file
\file{caribou.R}, located at the specified \code{modulePath(simList)} (see below).}

\item{objects}{An optional list of data objects to be used in the simulation.}

\item{paths}{An optional named list with up to 4 named elements,
\code{modulePath}, \code{inputPath}, \code{outputPath}, and \code{cachePath}.
See details.}

\item{inputs}{A \code{data.frame}. Can specify from 1 to 6
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{interval} (numeric), \code{loadTime} (numeric). See \code{?simInit}.
See \code{\link{inputs}} and vignette("ii-modules") section about inputs.}

\item{outputs}{A \code{data.frame}. Can specify from 1 to 5
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{saveTime} (numeric). See \code{?simInit}. See \code{\link{outputs}} and
\code{vignette("ii-modules")} section about outputs.}

\item{loadOrder}{An optional list of module names specfiying the order in
which to load the modules. If not specified, the module
load order will be determined automatically.}
}
\value{
A \code{simList} simulation object, pre-initialized from values
specified in the arguments supplied.
}
\description{
Create a new simulation object, the "sim" object. This object is implemented
using an \code{environment} where all objects and functions are placed.
Since environments in \code{R} are
pass by reference, "putting" objects in the sim object does no actual copy. This
is also the location of all parameters, and other important simulation information, such
as times, paths, modules, and module load order. See more details below.
}
\details{
Calling this simInit function does several things including the following:
- sources all module files, placing all function definitions in the sim object
- optionally copies objects from the global environment to the sim object
- optionally loads objects from disk
- schedules all "init" events from all modules
- assesses module dependencies via the inputs and outputs identified in their metadata
- determines time units of modules and how they fit together

We implement a discrete event simulation in a more modular fashion so it is
easier to add modules to the simulation. We use S4 classes and methods,
and use \code{data.table} instead of \code{data.frame} to implement the event
queue (because it is much faster).

\code{paths} specifies the location of the module source files,
the data input files, and the saving output files. If no paths are specified,
default is current working directory.
}
\examples{
\dontrun{
 mySim <- simInit(
   times = list(start = 0.0, end = 2.0, timeunit = "year"),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = system.file("sampleModules", package = "SpaDES"))
 )
 spades(mySim)

# A little more complicated with inputs and outputs
 mapPath <- system.file("maps", package = "SpaDES")
 mySim <- simInit(
   times = list(start = 0.0, end = 2.0, timeunit = "year"),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = system.file("sampleModules", package = "SpaDES"),
                outputPath = tempdir()),
   inputs = data.frame(
     files = dir(file.path(mapPath), full.names = TRUE, pattern = "tif")[1:2],
     functions = "raster",
     package = "raster",
     loadTime = 3,
     stringsAsFactors = FALSE),
   outputs = data.frame(
     expand.grid(objectName = c("caribou","landscape"),
     saveTime = 1:2,
     stringsAsFactors = FALSE))
 )
 spades(mySim)
}

}
\author{
Alex Chubaty and Eliot McIntire
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3). San Fransisco, CA: No Starch Press, Inc.. Retrieved from \url{http://www.nostarch.com/artofr.htm}
}
\seealso{
\code{\link{spades}}.
}

