% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleCoverage.R
\docType{methods}
\name{moduleCoverage}
\alias{moduleCoverage}
\alias{moduleCoverage,character,character-method}
\alias{moduleCoverage,character,missing-method}
\title{Calculate module coverage of unit tests}
\usage{
moduleCoverage(name, path)

\S4method{moduleCoverage}{character,character}(name, path)

\S4method{moduleCoverage}{character,missing}(name)
}
\arguments{
\item{name}{Character string. The module's name.}

\item{path}{Character string. The path to the module directory
(default is the current working directory).}
}
\value{
Return two coverage objects: moduleCoverage and functionCoverage.
The moduleCoverage contains percentage of coverage by unit tests for the module.
The functioinCoverage contains percentages of coverage by unit tests for functions in the module.
The returned two objects are compatible to \code{shine} function in \code{covr} package.
Please use \code{shine} to view the information of coverage.
}
\description{
Calculate the test coverage by unit tests for the module and its functions.
}
\note{
For running this function, the tests file must be restrictly placed in tests/testthat folder under module path.
      To automatically generate this folder, please set unitTests = TRUE when develop a new module using \code{\link{newModule}}.
}
\examples{
\dontrun{
 library(magrittr)
 library(SpaDES)
 tmpdir <- tempdir()
 modulePath <- file.path(tmpdir, "Modules") \%>\% checkPath(create = TRUE)
 moduleName <- "forestAge" # sample module to test
 downloadModule(name = moduleName, path = modulePath) # download sample module
 testResults <- moduleCoverage(name = moduleName, path = modulePath)
 shine(testResults$moduleCoverage)
 shine(testResults$functionCoverage)
 unlink(tmpdir, recursive = TRUE)
}
}
\author{
Yong Luo
}
\seealso{
\code{\link{newModule}}.
}

