% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{params}
\alias{checkpointFile}
\alias{checkpointFile,simList-method}
\alias{checkpointFile<-}
\alias{checkpointFile<-,simList-method}
\alias{checkpointInterval}
\alias{checkpointInterval,simList-method}
\alias{checkpointInterval<-}
\alias{checkpointInterval<-,simList-method}
\alias{globals}
\alias{globals,simList-method}
\alias{globals<-}
\alias{globals<-,simList-method}
\alias{outputPath}
\alias{outputPath,simList-method}
\alias{outputPath<-}
\alias{outputPath<-,simList-method}
\alias{params}
\alias{params,simList-method}
\alias{params<-}
\alias{params<-,simList-method}
\alias{progressInterval}
\alias{progressInterval,simList-method}
\alias{progressInterval<-}
\alias{progressInterval<-,simList-method}
\alias{progressType}
\alias{progressType,simList-method}
\alias{progressType<-}
\alias{progressType<-,simList-method}
\alias{simList-accessors-params}
\title{Get and set simulation parameters.}
\usage{
params(object)

\S4method{params}{simList}(object)

params(object) <- value

\S4method{params}{simList}(object) <- value

checkpointFile(object)

\S4method{checkpointFile}{simList}(object)

checkpointFile(object) <- value

\S4method{checkpointFile}{simList}(object) <- value

checkpointInterval(object)

\S4method{checkpointInterval}{simList}(object)

checkpointInterval(object) <- value

\S4method{checkpointInterval}{simList}(object) <- value

progressType(object)

\S4method{progressType}{simList}(object)

progressType(object) <- value

\S4method{progressType}{simList}(object) <- value

progressInterval(object)

\S4method{progressInterval}{simList}(object)

progressInterval(object) <- value

\S4method{progressInterval}{simList}(object) <- value

globals(object)

\S4method{globals}{simList}(object)

globals(object) <- value

\S4method{globals}{simList}(object) <- value

outputPath(object)

\S4method{outputPath}{simList}(object)

outputPath(object) <- value

\S4method{outputPath}{simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{params} slot of a \code{simList} object
and its elements.
Additonal methods are provided to access core module and global parameters:
Commonly used
\tabular{ll}{
   \code{globals} \tab List of global simulation parameters.\cr
   \code{params} \tab Nested list of all simulation parameter.\cr
}
Advanced use
\tabular{lll}{
   Accessor method \tab Module \tab Description \cr
   \code{checkpointFile} \tab \code{.checkpoint} \tab Name of the checkpoint file. (advanced)\cr
   \code{checkpointInterval} \tab \code{.checkpoint} \tab The simulation checkpoint interval. (advanced)\cr
   \code{modulePath} \tab \code{NA} \tab Global simulation module path. (advanced)\cr
   \code{outputPath} \tab \code{NA} \tab Global simulation output path. (advanced)\cr
   \code{inputPath} \tab \code{NA} \tab Global simulation input path. (advanced)\cr
   \code{paths} \tab \code{NA} \tab Global simulation paths (modules, inputs, outputs). (advanced)\cr
   \code{inputs} \tab \code{inputs} \tab data.frame identifying objects to load, files etc. & arguments (optional). (advanced)\cr
   \code{outputs} \tab \code{outputs} \tab data.frame identifying objects to save, files etc. & arguments (optional). (advanced)\cr
   \code{progressType} \tab \code{.progress} \tab Type of graphical progress bar used. (advanced)\cr
   \code{progressInterval} \tab \code{.progress} \tab Interval for the progress bar. (advanced)\cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-times}}.
}

