% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-spades.R
\name{scheduleConditionalEvent}
\alias{scheduleConditionalEvent}
\title{Schedule a conditional simulation event}
\usage{
scheduleConditionalEvent(
  sim,
  condition,
  moduleName,
  eventType,
  eventPriority = .pkgEnv$.normalVal,
  minEventTime = start(sim),
  maxEventTime = end(sim)
)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{condition}{A string, call or expression that will be assessed for \code{TRUE}
after each event in the regular event queue.
It can access objects in the \code{simList} by using functions of \code{sim},
e.g., \code{"sim$age > 1"}}

\item{moduleName}{A character string specifying the module from which to
call the event. If missing, it will use
\code{currentModule(sim)}}

\item{eventType}{A character string specifying the type of event from
within the module.}

\item{eventPriority}{A numeric specifying the priority of the event.
Lower number means higher priority. As a best practice, it is
recommended that decimal values are conceptual
grouped by their integer values (e.g., 4.0, 4.25, 4.5 are conceptually
similar).
See \code{\link{priority}}.}

\item{minEventTime}{A numeric specifying the time before which the event should not occur,
even if the condition is met. Defaults to \code{start(sim)}}

\item{maxEventTime}{A numeric specifying the time after which the event should not occur,
even if the condition is met. Defaults to \code{end(sim)}}
}
\value{
Returns the modified \code{simList} object, i.e., \code{sim$._conditionalEvents}.

This conditional event queue will be assessed at every single event in the normal event
queue. If there are no conditional events, then \code{spades} will proceed as normal.
As conditional event conditions are found to be true, then it will trigger a call to
\code{scheduleEvent(...)} with the current time passed to \code{eventTime} \emph{and}
it will remove the conditional event from the conditional queue.
If the user would like the triggered conditional event to occur as the very next event,
then a possible strategy would be to set \code{eventPriority} of the conditional event
to very low or even negative to ensure it gets inserted at the top of the event queue.
}
\description{
Adds a new event to the simulation's conditional event queue,
updating the simulation object by creating or appending to
\code{sim$._conditionalEvents}. This is very experimental. Use with caution.
}
\examples{
  sim <- simInit(times = list(start = 0, end = 2))
  condition <- "sim$age > 1" # provide as string
  condition <- quote(sim$age > 1) # provide as a call
  condition <- expression(sim$age > 1) # provide as an expression
  sim <- scheduleConditionalEvent(sim, condition, "firemodule", "burn")
  conditionalEvents(sim)
  sim <- spades(sim) # no changes to sim$age, i.e., it is absent
  events(sim) # nothing scheduled
  sim$age <- 2 # change the value
  sim <- spades(sim) # Run spades, the condition is now true, so event is
                     #  scheduled at current time
  events(sim)        # now scheduled in the normal event queue
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3).
            San Francisco, CA: No Starch Press, Inc..
            Retrieved from \url{https://nostarch.com/artofr.htm}
}
\seealso{
\code{\link{scheduleEvent}}, \code{\link{conditionalEvents}}
}
\author{
Eliot McIntire
}
