% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{modules}
\alias{modules}
\alias{simList-accessors-modules}
\alias{modules,simList-method}
\alias{modules<-}
\alias{modules<-,simList-method}
\alias{depends}
\alias{depends,simList-method}
\alias{depends<-}
\alias{depends<-,simList-method}
\title{Simulation modules and dependencies}
\usage{
modules(sim, hidden = FALSE)

\S4method{modules}{simList}(sim, hidden = FALSE)

modules(sim) <- value

\S4method{modules}{simList}(sim) <- value

depends(sim)

\S4method{depends}{simList}(sim)

depends(sim) <- value

\S4method{depends}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{hidden}{Logical. If TRUE, show the default core modules.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{depends} and \code{modules} slots in a
\code{simList} object.
These are included for advanced users.
\tabular{ll}{
\code{\link{depends}} \tab List of simulation module dependencies. (advanced) \cr
\code{\link{modules}} \tab List of simulation modules to be loaded. (advanced) \cr
\code{\link{inputs}} \tab List of loaded objects used in simulation. (advanced) \cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\seealso{
\code{\link{SpaDES.core-package}}, specifically the section 1.2.7 on Modules and dependencies.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{doEvent.checkpoint}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\author{
Alex Chubaty
}
\concept{functions to access elements of a 'simList' object}
