% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{LR_database}
\alias{LR_database}
\title{Identify Possible Ligand-Receptor Pairs for Cell-Cell Communication}
\usage{
LR_database(
  species,
  database_name,
  gene_spot_expression_dataframe,
  percentage = 10
)
}
\arguments{
\item{species}{A string specifying the species (\code{"Human"} or \code{"Mouse"}).}

\item{database_name}{A string specifying the L-R database to use. Options include \code{"CellChat"}, \code{"CellPhoneDB"}, \code{"Cellinker"}, \code{"ICELLNET"}, and \code{"ConnectomeDB"}.}

\item{gene_spot_expression_dataframe}{A gene expression data frame with genes as row names and Spot IDs as column names. This data frame is used to verify the presence of all genes involved in the L-R pairs.}

\item{percentage}{A numeric value specifying the minimum percentage of spots in which a gene must be expressed to be considered. The default is \code{10}, meaning the gene express over 10\% of spots.}
}
\value{
A list containing:
\describe{
  \item{\code{possible_LR_pairs}}{A data frame of L-R pairs where all genes are present in the \code{gene_spot_expression_dataframe} and meet the expression threshold. The data frame includes the ligand and receptor vectors, and the combined gene vectors.}
  \item{\code{possible_LR_pairs_info}}{A data frame with detailed information about the identified L-R pairs, including their original annotations from the selected database.}
}
}
\description{
This function identifies possible ligand-receptor (L-R) pairs for cell-cell communication analysis using a selected database. It checks for the presence of all genes involved in each L-R pair within the provided gene expression matrix, filtering based on a specified expression percentage threshold. The function supports multiple databases including CellChat, CellPhoneDB, Cellinker, ICELLNET, and ConnectomeDB.
}
\examples{
library(SpaCCI)
#Load the example data
data(test_data)
gene_spot_df <- test_data$gene_spot_df
result <- LR_database(species = "Human",
            database_name = "CellChat",
            gene_spot_expression_dataframe = gene_spot_df)
}
