% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visiualization.R
\name{plot_SpaCCI_chordDiagram}
\alias{plot_SpaCCI_chordDiagram}
\title{Plot SpaCCI Results on Chord Diagram}
\usage{
plot_SpaCCI_chordDiagram(
  SpaCCI_Result_List,
  specific_celltypes = NULL,
  pathway_name = NULL,
  L_R_pair_name = NULL,
  color = NULL,
  alpha = 0.05
)
}
\arguments{
\item{SpaCCI_Result_List}{A list containing the results from a SpaCCI \code{"regional"} or \code{"global"} analysis. This list should include \code{pvalue_df}, which are the outputs from \code{run_SpaCCI(..., analysis_scale = "regional",...)} or  \code{run_SpaCCI(..., analysis_scale = "global",...)}.}

\item{specific_celltypes}{A character vector specifying the cell types to include in the plot, RECOMMEND using colnames of cell type proportion matrix to include all cell types. If \code{NULL}, cell types that involved in significant interactions are included.}

\item{pathway_name}{A single character string specifying the pathway name to filter the interactions. If \code{NULL}, all pathways are included.}

\item{L_R_pair_name}{A character vector specifying the ligand-receptor pair names to include in the plot. If \code{NULL}, all interactions are included.}

\item{color}{A named vector of colors to use for the cell types. If \code{NULL}, a default color palette is used.}

\item{alpha}{A numeric value specifying the significance threshold for adjusted P-values. Initially, set to \code{0.05}.}
}
\value{
A chord diagram plot visualizing the significant cell-cell interactions.
}
\description{
This function generates a chord diagram to visualize cell-cell interactions based on ligand-receptor pairs. The interactions can be filtered by specific cell types, pathways, or interaction names.
}
\examples{
library(SpaCCI)
library(dplyr)
library(circlize)
data(result_global)
celltypes <- c("beta" , "delta" , "ductal","macrophage",
                "activated_stellate", "quiescent_stellate")
# Run the result chordDiagram for global analysis
plot_SpaCCI_chordDiagram(SpaCCI_Result_List = result_global,
                         specific_celltypes = c(celltypes),
                         L_R_pair_name  = "AREG_EGFR")

}
