% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplifyLinearNetwork.R
\name{SimplifyLinearNetwork}
\alias{SimplifyLinearNetwork}
\title{Simplifies a linear network object by merging the edges that meet at a second-degree vertex if some conditions on the angle they form and on their lengths are satisfied}
\usage{
SimplifyLinearNetwork(network, Angle = NULL, Length = NULL, M = NULL)
}
\arguments{
\item{network}{- A \code{linnet} object representing a linear network structure}

\item{Angle}{- An angle (in degrees, from 0 to 90) to adjust the level of simplification performed by the algorithm}

\item{Length}{- A length (in meters) to adjust the level of simplification performed by the algorithm}

\item{M}{- A k x 2 \code{matrix} that represents a combined effect for the \code{Angle} and \code{Length} parameters. First column represents a partition of the length space, whereas the second contains the angles considered in the simplification procedure when the lengths of both edges meeting in a second-degree vertex are below the threshold indicated in the first column}
}
\value{
Returns a simplification of the linear network passed as an input (linnet class)
}
\description{
This algorithm attempts to automatically reduce a linear network's complexity without altering its basic geometric configuration. The main objective of the algorithm is to merge the pairs of edges of the network that are connected by a second-degree vertex (with only two incident edges) into only one edge. Equivalently, this action means to join two vertex of the network whose path of connection only passes through another vertex of the network.
}
\examples{
library(SpNetPrep)
library(spatstat)
library(sp)
library(raster)
library(maptools)
network <- chicago$domain
Angle <- 10
Length <- 20
simplified_network_1 <- SimplifyLinearNetwork(network,Angle=Angle,Length=Length)
\dontrun{
M <- matrix(c(10,60,40,25),nrow=2)
simplified_network_2 <- SimplifyLinearNetwork(network,M=M)
}
}
