% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoftClassForest.R
\name{SoftClassForest}
\alias{SoftClassForest}
\title{Implementing a Random Forest of SDTs.}
\usage{
SoftClassForest(trainresponses, train, test, ntry, ntrees, depth,
  bag = TRUE)
}
\arguments{
\item{trainresponses}{A matrix or data frame of responses \code{0} and \code{1} for the training set with length equal to the number of observations in the training set and width equal to the number of possible classifications.}

\item{train}{A matrix or data frame consisting of all possible variables to attempt for the training set.}

\item{test}{A matrix or data frame consisting of all possible variables to attempt for the test set.}

\item{ntry}{A numeric of the number of variables from the \code{num.features} to attempt to split.  This is useful for building random forests.  For a standard tree, choose \code{ntry = num.features}.}

\item{ntrees}{A numeric of the number of SDTs to build in the Random Forest.}

\item{depth}{A numeric of the number of the depth each SDT should be.  Here this ends with \eqn{2^{depth - 1}} terminal nodes.}

\item{bag}{Logical if Random Forests should be built with bootstrap aggregating (TRUE) or raw data (FALSE).}
}
\value{
A vector of the final classifications based on the Random Forest generated.
}
\description{
\code{SoftClassForest} creates categorical Random Forests of Soft Decision Trees while returning
the fitted classification given by the majority vote of individual SDTs.
}
\details{
\code{SoftClassForest} individually fits a Random Forest for each possible classification response using \code{SoftForestPredFeeder} function
one classification at a time.  The result from each one of these SDTs is a fitted probability of \code{0} or \code{1}.
Once all classifications have a fitted probability, the observation is classified as the maximum a posteriori probability.
Given a Random Forest of SDTs, the final Random Forest classification goes to the majority vote from the SDTs.
}
\examples{
Responses = SoftClassMatrix(as.vector(iris$Species))
SoftClassForest(trainresponses = Responses, train = iris[,1:4], test = iris[,1:4], 
ntry = 2, ntrees = 15, depth = 2, bag = TRUE)
}
