% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_categorical.R
\name{ExpCTable}
\alias{ExpCTable}
\title{Function to create frequency and custom tables}
\usage{
ExpCTable(data, Target = NULL, margin = 1, clim = 10, nlim = 10,
  round = 2, bin = 3, per = FALSE)
}
\arguments{
\item{data}{dataframe or matrix}

\item{Target}{target variable (dependent variable) if any. Default NULL}

\item{margin}{margin of index, 1 for row based proportions and 2 for column based proportions}

\item{clim}{maximum categories to be considered for frequency/custom table. Variables will be dropped if unique levels are higher than 'clim' for class factor/character variable. Default value is 10.}

\item{nlim}{numeric variable unique limits. Default 'nlim' values is 3, table excludes the numeric variables which is having greater than 'nlim' unique values}

\item{round}{round off}

\item{bin}{number of cuts for continuous target variable}

\item{per}{percentage values. Default table will give counts.}
}
\value{
Frequency tables, Cross tables

 Columns description for frequency tables:

\itemize{
  \item \code{Variable} is Variable name
  \item \code{Valid} is Variable values
  \item \code{Frequency} is Frequency
  \item \code{Percent} is Relative frequency
  \item \code{CumPercent} is Cumulative sum of relative frequency
}

 Columns description for custom tables:

\itemize{
  \item \code{Variable} is Variable name
  \item \code{Category} is Variable values
  \item \code{Count} is Number of counts
  \item \code{Per} is Percentages
  \item \code{Total} is Total count
}
}
\description{
this function will automatically select categorical variables and generate frequency or cross tables based on the user inputs. Output includes counts, percentages, row total and column total.
}
\details{
this function provides both frequency and custom tables for all categorical features. And ouput will be generated in data frame
}
\examples{
# Frequency table
ExpCTable(mtcars, Target = NULL, margin = 1, clim = 10, nlim = 3, bin = NULL, per = FALSE)
# Crosstbale for Mtcars data
ExpCTable(mtcars, Target = "gear", margin = 1, clim = 10, nlim = 3, bin = NULL, per = FALSE)

}
