% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree_coef.R
\name{agree_coef}
\alias{agree_coef}
\title{Agreement Coefficents}
\usage{
agree_coef(
  wide = TRUE,
  col.names = NULL,
  measure,
  item,
  id,
  data,
  weighted = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{wide}{Logical value (TRUE or FALSE) indicating if data is in a "wide" format. Default is TRUE.}

\item{col.names}{If wide is equal to TRUE then col.names is a list of the column names containing the measurements for reliability analysis.}

\item{measure}{Name of column containing the measurement of interest.}

\item{item}{Name of column containing the items. If this is an inter-rater reliability study then this would indicate the rater (e.g., rater1, rater2, rater3, etc).}

\item{id}{Column with subject identifier.}

\item{data}{Data frame with all data.}

\item{weighted}{Logical value (TRUE or FALSE) indicating whether to weight the responses. If TRUE (default is FALSE) then quadratic weights are utilized. This option should be set to TRUE for ordinal or continuous responses.}

\item{conf.level}{the confidence level required. Default is 95\%.}
}
\value{
Returns single data frame of inter-rater reliability coefficients.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

agree_coef produces inter-rater reliability or "agreement coefficients" as described by Gwet.
}
\examples{
data('reps')
agree_coef(data = reps, wide = TRUE, col.names = c("x","y"), weighted = TRUE)

}
\references{
Gwet, K.L. (2014, ISBN:978-0970806284). “Handbook of Inter-Rater Reliability,” 4th Edition. Advanced Analytics, LLC.
Gwet, K. L. (2008). “Computing inter-rater reliability and its variance in the presence of high agreement," British Journal of Mathematical and Statistical Psychology, 61, 29-48.
}
