% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimPieceSCR.R
\name{SimSCRPiecewise}
\alias{SimSCRPiecewise}
\title{SimSCRPiecewise}
\usage{
SimSCRPiecewise(x1, x2, x3, beta1, beta2, beta3, s1, s2, s3, lam1, lam2, lam3,
  gamma, cens)
}
\arguments{
\item{x1}{- Matrix of patient covariates for hazard 1 simulation}

\item{x2}{- Matrix of patient covariates for hazard 2 simulation}

\item{x3}{- Matrix of patient covariates for hazard 3 simulation}

\item{beta1}{- vector of size ncol(x1) that is the true regression coefficient vector for hazard 1}

\item{beta2}{- vector of size ncol(x2) that is the true regression coefficient vector for hazard 2}

\item{beta3}{- vector of size ncol(x3) that is the true regression coefficient vector for hazard 3}

\item{s1}{- vector of size at least length 2, where the first entry is 0. This characterizes the split point locations of baseline hazard 1}

\item{s2}{- vector of size at least length 2, where the first entry is 0. This characterizes the split point locations of baseline hazard 2}

\item{s3}{- vector of size at least length 2, where the first entry is 0. This characterizes the split point locations of baseline hazard 3}

\item{lam1}{- vector of the same size as s1. This vector is the true baseline hazard 1 heights and the last entry represents the height on the interval [max(s1),infinity)}

\item{lam2}{- vector of the same size as s2. This vector is the true baseline hazard 2 heights and the last entry represents the height on the interval [max(s2),infinity)}

\item{lam3}{- vector of the same size as s3. This vector is the true baseline hazard 3 heights and the last entry represents the height on the interval [max(s3),infinity)}

\item{gamma}{- vector containing patient frailties.}

\item{cens}{- This is the administrative right censoring time of the study. All patients who have survival outcomes after cens have survival times set to cens.}
}
\value{
Returns a list of size 4 containing the semi-competing risks simulated data. Entry 1 contains the non-terminal event times for the patients.
Entry 2 contains the terminal event times for the patients. Entry 3 contains the patient indicators for whether or not a patient experienced a non-terminal event prior to death.
Entry 4 contains the patient indicators for whether or not they experienced a terminal event.
}
\description{
This function simulates semi-competing risks data based on three piecewise exponential hazards, three true regression vectors and three matrices of patient covariates (which can be different or the same).
This simulates from the semi-markov model of Lee et al (2015) given patient covariates, regression parameters and baseline hazard functions.
}
\examples{
##Set number of patients and covariate matrices
n=100
x1=matrix(rnorm(n*10,0,1),nrow=n)
x2=x1
x3=x1
##Sets up true covariate vectors
beta1=rnorm(10,0,1)
beta2=rnorm(10,0,1)
beta3=c(3,rep(0,9))
##Sets up three baseline hazard split locations
s1=c(0,7,30,100,1000)
s2=c(0,50,100,2000)
s3=c(0,10,40,50,500)
##Sets up baseline hazard heights
lam1=c(.1,.1,.3,.1,.1)
lam2=c(.2,.3,.1,.1)
lam3=c(.1,.3,.2,.2,.1)
gamma=rgamma(100,1,1)
##Runs Function and returns a list of simulated data
X=SimSCRPiecewise(x1,x2,x3,beta1,beta2,beta3,s1,s2,s3,lam1,lam2,lam3,gamma,1000)
X

}
\references{
Lee, K. H., Haneuse, S., Schrag, D. and Dominici, F. (2015), Bayesian semiparametric analysis of semicompeting risks data: investigating hospital readmission after a pancreatic cancer diagnosis. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 253-273.
}

