% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimPieceUNI.R
\name{SimUNIVPiecewise}
\alias{SimUNIVPiecewise}
\title{SimSCRPiecewise
This function simulates semi-competing risks data based on three piecewise exponential hazards, three true regression vectors and three matrices of patient covariates (which can be different or the same).
This simulates from the semi-markov model of Lee et al (2015) given patient covariates, regression parameters and baseline hazard functions.}
\usage{
SimUNIVPiecewise(x1, beta1, s1, lam1, cens)
}
\arguments{
\item{x1}{- Matrix of patient covariates for hazard 1 simulation}

\item{beta1}{- vector of size ncol(x1) that is the true regression coefficient vector for the baseline hazard function}

\item{s1}{- vector of size at least length 2, where the first entry is 0. This characterizes the split point locations of baseline hazard}

\item{lam1}{- vector of the same size as s1. This vector is the true baseline hazard heights and the last entry represents the height on the interval [max(s1),infinity)}

\item{cens}{- This is the administrative right censoring time of the study. All patients who have survival outcomes after cens have survival times set to cens.}
}
\value{
Returns a list of size 4 containing the semi-competing risks simulated data. Entry 1 contains the non-terminal event times for the patients.
Entry 2 contains the terminal event times for the patients. Entry 3 contains the patient indicators for whether or not a patient experienced a non-terminal event prior to death.
Entry 4 contains the patient indicators for whether or not they experienced a terminal event.
}
\description{
SimSCRPiecewise
This function simulates semi-competing risks data based on three piecewise exponential hazards, three true regression vectors and three matrices of patient covariates (which can be different or the same).
This simulates from the semi-markov model of Lee et al (2015) given patient covariates, regression parameters and baseline hazard functions.
}
\examples{
##Set number of patients and covariate matrices
n=100
x1=matrix(rnorm(n*10,0,1),nrow=n)
##Sets up true covariate vector
beta1=rnorm(10,0,1)
##Sets up true baseline hazard split locations
s1=c(0,7,30,100,1000)
##Sets up baseline hazard heights
lam1=c(.1,.1,.3,.1,.1)
##Runs Function and returns a list of simulated data
X=SimUNIVPiecewise(x1,beta1,s1,lam1,1000)
X

}
\references{
Lee, K. H., Haneuse, S., Schrag, D. and Dominici, F. (2015), Bayesian semiparametric analysis of semicompeting risks data: investigating hospital readmission after a pancreatic cancer diagnosis. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 253-273.
}

