% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{s}
\alias{s}
\title{Evaluate asymmetric similarity function}
\usage{
s(term_sim_mat, term_descendancy_matrix, phi, x = NULL,
  case_ids = unlist(mapply(SIMPLIFY = FALSE, FUN = rep, 0:(length(x) - 1),
  sapply(x, length))), term_ids = as.integer(match(unlist(x),
  colnames(term_sim_mat))) - 1, num_cases = length(x),
  average_across_phi = TRUE)
}
\arguments{
\item{term_sim_mat}{Numeric matrix of similarities between individual terms, typically created with \code{get_term_sim_mat}}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}

\item{phi}{Character vector of term IDs for phi (or character matrix, where each row is an instance of phi)}

\item{x}{List of character vectors of terms IDs.}

\item{case_ids}{IDs for the N cases from 0 to N-1, indicating which case terms in \code{term_ids} belong to (automatically determined given x).}

\item{term_ids}{Vector of HPO term IDs belonging to cases.}

\item{num_cases}{Number of individuals (automatically determined if \code{x} is given}

\item{average_across_phi}{Logical value determining whether to use the s_phi function, averaging over similarities to terms in phi, or the s_x, averaging across the best matches to the terms in \code{x}.}
}
\value{
Numeric vector of similarities between phi and \code{x}, or if phi is a matrix, numeric matrix where rows correspond to similarities between x and rows of phi.
}
\description{
Evaluate asymmetric similarity function
}

