% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getfrequency.R
\name{count.allele}
\alias{count.allele}
\title{Count allele frequencies}
\usage{
count.allele(x, ...)
}
\arguments{
\item{x}{a vector of single SNP information (minor allele count for genotype).}

\item{...}{not used.}
}
\value{
a vector with major and minor allele frequency.
}
\description{
Count major and minor allele frequencies.
}
\examples{
maf <- 0.1
x <- sample(0:2, 1000, replace = TRUE, prob = c((1-maf)^2, 2*(1-maf)*maf, maf^2))
table(x)
count.allele(x)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de} and
        Benno Pütz \email{puetz@psych.mpg.de}
}
