% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\docType{methods}
\name{boxplot-methods}
\alias{boxplot-methods}
\alias{boxplot}
\alias{boxplot,SimInf_model-method}
\title{Box Plots}
\usage{
\S4method{boxplot}{SimInf_model}(x, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{...}{Additional arguments affecting the plot produced.}
}
\description{
Produce box-and-whisker plot(s) of the number of individuals in
each compartment.
}
\examples{
## Create an 'SIR' model with 10 nodes and initialise
## it with 99 susceptible individuals and one infected
## individual. Let the model run over 100 days.
model <- SIR(u0 = data.frame(S = rep(99, 10),
                             I = rep(1, 10),
                             R = rep(0, 10)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model, threads = 1, seed = 1)

## Create a boxplot
boxplot(result)
}
