% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.size.at.equilibr.R
\name{RNV.size.at.equilibr}
\alias{RNV.size.at.equilibr}
\title{Plot and linear model of RNV size at equilibrium}
\usage{
RNV.size.at.equilibr(n_fun,correl_fun,N_fun,A_fun=NA,B_fun=NA,E0_fun=NA,
Etot_0=sum(E0_fun),Etot_eq=100,A_lim=c(0.001,10000),inv_B_lim=c(0,100),E0_lim=c(1,100),
RNV.by.E=FALSE,show.plot=TRUE,enz.lab=FALSE,...)
}
\arguments{
\item{n_fun}{Integer number indicating the number of enzymes.}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{N_fun}{Numeric. Population size}

\item{A_fun, B_fun, E0_fun}{Numeric vectors (length \code{n_fun}) of activities, global co-regulation coefficients and initial concentrations respectively.
If \code{NA} (default), values are randomly chosen.}

\item{Etot_0}{Numeric value of initial total concentration. \code{E0_fun} is rescaled to have \code{sum(E0_fun)=Etot_0}.}

\item{Etot_eq}{Numeric value of total concentration at equilibrium for cases \code{"SC"} and \code{"RegPos"}. Default is \code{100}.}

\item{A_lim}{Numeric vector of the two limits between which activities are chosen if \code{A_fun=NA}.}

\item{inv_B_lim}{Numeric vector of the two limits between which inverse of global co-regulations \code{B} are chosen if \code{B_fun=NA}.}

\item{E0_lim}{Numeric vector of the two limits between which initial concentrations \code{E0} are chosen if \code{E0_fun=NA}.}

\item{RNV.by.E}{Logical. Show RNV divided by Ei rather than RNV size?}

\item{show.plot}{Logical. Show plot of RNV in relation to RNV-ranking-order factor?}

\item{enz.lab}{Logical. Add enzyme name above points in graphics?}

\item{...}{Arguments to be passed to \code{plot} function, such \code{cex} or \code{cex.lab}}
}
\value{
Invisible list of 12 elements:
\itemize{
   \item \code{$RNV_size}: matrix of one or two rows and \code{n} columns indicating the RNV size of every enzymes (in columns) and current RNV (near or far, in rows). See output \code{$RNV_size} of function \code{\link{RNV.for.simul}};
   \item \code{$lm_RNV}: linear model of RNV size in relation to the ranking-order variable;
   \item \code{$E_eq}: numeric vector (length \code{n}) of concentrations at equilibrium;
   \item \code{$e_eq}: numeric vector (length \code{n}) of relative concentrations at equilibrium;
   \item \code{$A}: numeric vector (length \code{n}) of activities;
   \item \code{$B}: numeric vector (length \code{n}) of global co-regulation coefficients;
   \item \code{$beta}: numeric matrix of \code{n} rows and \code{n} columns indicating the co-regulation coefficients;
   \item \code{$E0}: numeric vector (length \code{n}) of initial concentrations;
   \item \code{$rank_var}: list of 2 elements: \itemize{
      \item \code{$value}: numeric vector (length \code{n}) of the RNV-ranking-order factor values for each enzyme \emph{(see details)};
      \item \code{$name}: character string indicating the name of the RNV-ranking-order factor.
   }
   \item \code{$N}, \code{$n}, \code{$correl}: numeric value of population size, number enzymes and applied constraints respectively (respectively input value of \code{N_fun}, \code{n_fun} and \code{correl_fun})
}
}
\description{
Gives a plot and computes a linear model of the RNV size at equilibrium against the activities and the RNV-ranking-order factor
}
\details{
Function \code{RNV.size.at.equilibr} gives a plot of RNV size in relation to activities, and then a plot of RNV size in relation to RNV-ranking-order-factor.

RNV size is computed at equilibrium with function \code{\link{RNV.for.simul}}. Only "near" RNV (small mutations) is used.

\bold{WARNING!} This function is not adapted or regulation groups (\code{1<sum(1/B)<n}).

\bold{Factors governing ranking order of RNV}

RNV-ranking-order factor depends on constraint. See function \code{\link{RNV.ranking.order.factor}}.


\bold{Random variables}

Input parameters \code{A_fun, B_fun, E0_fun} are chosen randomly if not specified (default \code{NA}).

Activities \code{A_fun} are taken in a uniform law between limits given by \code{A_lim}.

Initial concentrations \code{E0_fun} are taken in a uniform law between limits given by \code{E0_lim}, then leveled to have sum of \code{E0_fun} equal to \code{Etot_fun}.

Global co-regulation coefficients \code{B_fun} are chosen differently. The inverse of \code{B} are taken between limits given by \code{inv_B_lim}.
If \code{correl_fun} is equal to \code{"RegNeg"} or \code{"CRNeg"} (negative co-regulations), sign are randomly chosen.
Then these inverse values are leveled to have sum of \code{1/B} equal to 1.
Thus \code{B} are computed by the reverse operation, and therefore the matrix of \code{beta} by function \code{\link{compute.beta.from.B}}.


\bold{Equilibrium}

RNV is computed at equilibrium, theoretical one for cases \code{"SC"}, \code{"Comp"} and \code{"RegPos"}, and effective one for cases \code{"RegNeg"}, \code{"CRPos"} and \code{"CRNeg"}.


\bold{Graphics}

If \code{RNV.by.E=TRUE}, RNV size divided by its corresponding enzyme concentration is plotted, rather than RNV size.
}
\examples{
RNV.size.at.equilibr(20,"Comp",1000)
RNV.size.at.equilibr(100,"CRNeg",1000)
RNV.size.at.equilibr(3,"SC",1000,c(1,10,30),NA,c(30,30,30),100,200)
 #in this case, sum(E0)=100 and sum(E*)=200



}
\seealso{
RNV is computed with the function \code{\link{RNV.for.simul}}. 

See function \code{\link{RNV.ranking.order.factor}} to have further details on RNV-ranking-order.
}
