% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.correl.authorized.R
\name{is.correl.authorized}
\alias{is.correl.authorized}
\title{Verification of constraint name}
\usage{
is.correl.authorized(correl_fun)
}
\arguments{
\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}
}
\value{
Returns TRUE if \code{correl_fun} is an authorized case, else stop
}
\description{
Verifies if the constraint is authorized for other functions or not
}
\details{
Verifies if constraint is included in the six allowed cases.

Possible constraints are listed below:
 \itemize{
   \item \code{"SC"}: independence between all enzymes 
   \item \code{"Comp"}: competition for resources 
   \item \code{"RegPos"}: positive regulation
   \item \code{"RegNeg"}: negative regulation 
   \item \code{"CRPos"}: competition plus positive regulation 
   \item \code{"CRNeg"}: competition plus negative regulation
}
}
\examples{
is.correl.authorized("SC")
#returns TRUE



}
\seealso{
Need help to correctly write \code{correl_fun}? Use function \code{\link{name.correl}}.
}
