% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{CorrStudySplit}
\alias{CorrStudySplit}
\title{Investigate the effect of correlated input parameters depending on illegal 
gain}
\usage{
CorrStudySplit(params, m = 1e+05, rho = seq(0.1, 0.9, by = 0.2),
  breaks = seq(0.1, 0.3, by = 0.04), QMC = FALSE, seed = 1)
}
\arguments{
\item{params}{named list containing numeric vectors Phi, Rho, Chi, 
Ksi, M, G and A with the ranges for the input parameters.}

\item{m}{numeric scalar containing the number of Monte Carlo
replications (for each correlation intensity). Defaults to \code{1e5}.}

\item{rho}{a numeric vector containing correlation intensities. Defaults to
\code{seq(0.1,0.9,by=0.2)}.}

\item{breaks}{a numeric vector with breaks for the construction of the 
intervals for the illegal gain \code{A}. Defaults to 
\code{seq(0.1,0.3,by=0.04)}.}

\item{QMC}{logical scalar. If \code{TRUE}, an equidistant grid is
generated, if \code{FALSE}, uniformly distributed random numbers are
simulated.}

\item{seed}{numeric scalar containing the random seed for each
simulation. Defaults to \code{1} in order to make results reproducible.}
}
\value{
A matrix containing the results of the repeated simulations.
}
\description{
\code{CorrStudySplit} investigates the effect of correlated input parameters
and its dependence on the illegal gain \code{A}.
}
\details{
\code{CorrStudySplit} performs repeated simulations via \code{LEgame} with
different values for the correlation intensity and reports results for 
compliance and expected illegal gain for various subsets of simulated
illegal gains \code{A} in order to further illustrate the effect of 
correlation on the deterrent effect of the legal exemption system.
}
\examples{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
res <- CorrStudySplit(params=Par, m=10000)
print(res)
}
