% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{CC}
\alias{CC}
\title{Compute congruence coefficient}
\usage{
CC(x, y = NULL, unname = FALSE)
}
\arguments{
\item{x}{a vector or \code{data.frame}/\code{matrix} containing the
variables to use. If a vector then the input \code{y} is required,
otherwise the cogruence coefficient is computed for all bivariate
combinations}

\item{y}{(optional) the second vector input to use if
\code{x} is a vector}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\description{
Computes the congruence coefficient, also known as an "unadjusted" correlation
or Tucker's congruence coefficient.
}
\examples{

vec1 <- runif(1000)
vec2 <- runif(1000)

CC(vec1, vec2)
# compare to cor()
cor(vec1, vec2)

# column input
df <- data.frame(vec1, vec2, vec3 = runif(1000))
CC(df)
cor(df)

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{cor}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
