% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{MAE}
\alias{MAE}
\title{Compute the mean absolute error}
\usage{
MAE(estimate, parameter = NULL, type = "MAE", percent = FALSE, unname = FALSE)
}
\arguments{
\item{estimate}{a \code{numeric} vector, \code{matrix}/\code{data.frame}, or \code{list}
of parameter estimates.
If a vector, the length is equal to the number of replications. If a
\code{matrix}/\code{data.frame} the number of rows must equal the number of replications.
\code{list} objects will be looped
over using the same rules after above after first translating the information into one-dimensional
vectors and re-creating the structure upon return}

\item{parameter}{a \code{numeric} scalar/vector or \code{matrix} indicating the fixed parameter values.
If a single value is supplied and \code{estimate} is a \code{matrix}/\code{data.frame}
then the value will be
recycled for each column; otherwise, each element will be associated
with each respective column in the \code{estimate} input.
If \code{NULL}, then it will be assumed that the \code{estimate} input is in a deviation
form (therefore \code{mean(abs(estimate))} will be returned)}

\item{type}{type of deviation to compute. Can be \code{'MAE'} (default) for the mean absolute error,
\code{'NMSE'} for the normalized MAE (MAE / (max(estimate) - min(estimate))), or
\code{'SMSE'} for the standardized MAE (MAE / sd(estimate))}

\item{percent}{logical; change returned result to percentage by multiplying by 100?
Default is FALSE}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\value{
returns a numeric vector indicating the overall mean absolute error in the estimates
}
\description{
Computes the average absolute deviation of a sample estimate from the parameter value.
Accepts estimate and parameter values, as well as estimate values which are in deviation form.
}
\examples{

pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
MAE(samp, pop)

dev <- samp - pop
MAE(dev)
MAE(samp, pop, type = 'NMAE')
MAE(samp, pop, type = 'SMAE')

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
MAE(mat, parameter = 2)

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
MAE(df, parameter = c(2,2))

# parameters of the same size
parameters <- 1:10
estimates <- parameters + rnorm(10)
MAE(estimates, parameters)

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
RMSE
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
