% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{ECR}
\alias{ECR}
\title{Compute the empirical coverage rate for Type I errors and Power}
\usage{
ECR(CIs, parameter)
}
\arguments{
\item{CIs}{a \code{numeric} vector or \code{matrix} of confidence interval values for a
given parameter value, where the first element/column indicates the lower confidence interval
and the second element/column the upper confidence interval. If a
vector of length 2 is passed instead then the returned value will be either a 1 or 0 to indicate
whether the parameter value was or was not within the interval, respectively}

\item{parameter}{a numeric scalar indicating the fixed parameter value}
}
\description{
Computes the detection rate for determining empirical Type I error and power rates using information
from the confidence intervals. Note that using \code{1 - ECR(CIs, parameter)} will provide the empirical
detection rate.
}
\examples{

CIs <- matrix(NA, 100, 2)
for(i in 1:100){
   dat <- rnorm(100)
   CIs[i,] <- t.test(dat)$conf.int
}

ECR(CIs, 0)

# single vector input
CI <- c(-1, 1)
ECR(CI, 0)
ECR(CI, 2)

}
\seealso{
\code{\link{EDR}}
}

