% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercorr2.R
\name{intercorr2}
\alias{intercorr2}
\title{Calculate Intermediate MVN Correlation for Ordinal, Continuous, Poisson, or Negative Binomial Variables: Correlation Method 2}
\usage{
intercorr2(k_cat = 0, k_cont = 0, k_pois = 0, k_nb = 0,
  method = c("Fleishman", "Polynomial"), constants = NULL,
  marginal = list(), support = list(), lam = NULL, p_zip = 0,
  size = NULL, prob = NULL, mu = NULL, p_zinb = 0, pois_eps = 0.0001,
  nb_eps = 0.0001, rho = NULL, epsilon = 0.001, maxit = 1000,
  quiet = FALSE)
}
\arguments{
\item{k_cat}{the number of ordinal (r >= 2 categories) variables (default = 0)}

\item{k_cont}{the number of continuous non-mixture variables and components of continuous mixture variables (default = 0)}

\item{k_pois}{the number of regular and zero-inflated Poisson variables (default = 0)}

\item{k_nb}{the number of regular and zero-inflated Negative Binomial variables (default = 0)}

\item{method}{the method used to generate the \code{k_cont} continuous variables.  "Fleishman" uses a third-order polynomial transformation
and "Polynomial" uses Headrick's fifth-order transformation.}

\item{constants}{a matrix with \code{k_cont} rows, each a vector of constants c0, c1, c2, c3 (if \code{method} = "Fleishman") or
c0, c1, c2, c3, c4, c5 (if \code{method} = "Polynomial") like that returned by \code{\link[SimMultiCorrData]{find_constants}}}

\item{marginal}{a list of length equal to \code{k_cat}; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1; default = list())}

\item{support}{a list of length equal to \code{k_cat}; the i-th element is a vector of containing the r
ordered support values; if not provided (i.e. \code{support} = list()), the default is for the i-th element to be the vector 1, ..., r}

\item{lam}{a vector of lambda (mean > 0) constants for the regular and zero-inflated Poisson variables (see \code{stats::dpois});
the order should be 1st regular Poisson variables, 2nd zero-inflated Poisson variables}

\item{p_zip}{a vector of probabilities of structural zeros (not including zeros from the Poisson distribution) for the
zero-inflated Poisson variables (see \code{VGAM::dzipois}); if \code{p_zip} = 0, \eqn{Y_{pois}} has a regular Poisson
distribution; if \code{p_zip} is in (0, 1), \eqn{Y_{pois}} has a zero-inflated Poisson distribution;
if \code{p_zip} is in \code{(-(exp(lam) - 1)^(-1), 0)}, \eqn{Y_{pois}} has a zero-deflated Poisson distribution and \code{p_zip}
is not a probability; if \code{p_zip = -(exp(lam) - 1)^(-1)}, \eqn{Y_{pois}} has a positive-Poisson distribution
(see \code{VGAM::dpospois}); if \code{length(p_zip) < length(lam)}, the missing values are set to 0 (and ordered 1st)}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{stats::dnbinom}); the order should be
1st regular NB variables, 2nd zero-inflated NB variables}

\item{prob}{a vector of success probability parameters for the NB variables; order the same as in \code{size}}

\item{mu}{a vector of mean parameters for the NB variables (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL); order the same as in \code{size}; for zero-inflated NB this refers to
the mean of the NB distribution (see \code{VGAM::dzinegbin})}

\item{p_zinb}{a vector of probabilities of structural zeros (not including zeros from the NB distribution) for the zero-inflated NB variables
(see \code{VGAM::dzinegbin}); if \code{p_zinb} = 0, \eqn{Y_{nb}} has a regular NB distribution;
if \code{p_zinb} is in \code{(-prob^size/(1 - prob^size),} \code{0)}, \eqn{Y_{nb}} has a zero-deflated NB distribution and \code{p_zinb}
is not a probability; if \code{p_zinb = -prob^size/(1 - prob^size)}, \eqn{Y_{nb}} has a positive-NB distribution (see
\code{VGAM::dposnegbin}); if \code{length(p_zinb) < length(size)}, the missing values are set to 0 (and ordered 1st)}

\item{pois_eps}{a vector of length \code{k_pois} containing total cumulative probability truncation values; if none are provided,
the default is 0.0001 for each variable}

\item{nb_eps}{a vector of length \code{k_nb} containing total cumulative probability truncation values; if none are provided,
the default is 0.0001 for each variable}

\item{rho}{the target correlation matrix which must be ordered
\emph{1st ordinal, 2nd continuous non-mixture, 3rd components of continuous mixtures, 4th regular Poisson, 5th zero-inflated Poisson,
6th regular NB, 7th zero-inflated NB}; note that \code{rho} is specified in terms of the components of \eqn{Y_{mix}}}

\item{epsilon}{the maximum acceptable error between the pairwise correlations (default = 0.001)
in the calculation of ordinal intermediate correlations with \code{\link[SimCorrMix]{ord_norm}}}

\item{maxit}{the maximum number of iterations to use (default = 1000) in the calculation of ordinal
intermediate correlations with \code{\link[SimCorrMix]{ord_norm}}}

\item{quiet}{if FALSE prints simulation messages, if TRUE suppresses message printing}
}
\value{
the intermediate MVN correlation matrix
}
\description{
This function calculates a \code{k x k} intermediate matrix of correlations, where \code{k = k_cat + k_cont +}
    \code{k_pois + k_nb}, to be used in simulating variables with \code{\link[SimCorrMix]{corrvar2}}.  The \code{k_cont} includes regular continuous variables
    and components of continuous mixture variables.  The ordering of the variables must be
    ordinal, continuous non-mixture, components of continuous mixture variables, regular Poisson, zero-inflated Poisson, regular Negative
    Binomial (NB), and zero-inflated NB (note that it is possible for \code{k_cat}, \code{k_cont}, \code{k_pois}, and/or \code{k_nb} to be 0).
    There are no parameter input checks in order to decrease simulation time.  All inputs should be checked prior to simulation with
    \code{\link[SimCorrMix]{validpar}}.  There is a message given if the calculated
    intermediate correlation matrix \code{Sigma} is not positive-definite because it may not be possible to find a MVN correlation
    matrix that will produce the desired marginal distributions.  This function is called by the simulation function
    \code{\link[SimCorrMix]{corrvar2}}, and would only be used separately if the user wants to first find the intermediate correlation matrix.
    This matrix \code{Sigma} can be used as an input to \code{\link[SimCorrMix]{corrvar2}}.

    Please see the \bold{Comparison of Correlation Methods 1 and 2} vignette for information about calculations by variable pair type and the differences between
    this function and \code{\link[SimCorrMix]{intercorr}}.
}
\examples{
Sigma1 <- intercorr2(k_cat = 1, k_cont = 1, method = "Polynomial",
  constants = matrix(c(0, 1, 0, 0, 0, 0), 1, 6), marginal = list(0.3),
  support = list(c(0, 1)), rho = matrix(c(1, 0.4, 0.4, 1), 2, 2),
  quiet = TRUE)
\dontrun{

# 1 continuous mixture, 1 binary, 1 zero-inflated Poisson, and
# 1 zero-inflated NB variable
# The defaults of pois_eps <- nb_eps <- 0.0001 are used.

# Mixture of N(-2, 1) and N(2, 1)
constants <- rbind(c(0, 1, 0, 0, 0, 0), c(0, 1, 0, 0, 0, 0))

marginal <- list(0.3)
support <- list(c(0, 1))
lam <- 0.5
p_zip <- 0.1
size <- 2
prob <- 0.75
p_zinb <- 0.2

k_cat <- k_pois <- k_nb <- 1
k_cont <- 2
Rey <- matrix(0.35, 5, 5)
diag(Rey) <- 1
rownames(Rey) <- colnames(Rey) <- c("O1", "M1_1", "M1_2", "P1", "NB1")

# set correlation between components of the same mixture variable to 0
Rey["M1_1", "M1_2"] <- Rey["M1_2", "M1_1"] <- 0

Sigma2 <- intercorr2(k_cat, k_cont, k_pois, k_nb, "Polynomial", constants,
  marginal, support, lam, p_zip, size, prob, mu = NULL, p_zinb, rho = Rey)
}
}
\references{
Please see references for \code{\link[SimCorrMix]{SimCorrMix}}.
}
\seealso{
\code{\link[SimCorrMix]{corrvar2}}
}
\keyword{correlation}
\keyword{method2}
