% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr_bias.r
\name{sr_bias}
\alias{sr_bias}
\title{sr_bias .}
\usage{
sr_bias(snr, n, cumulants, type = c("simple", "second_order"))
}
\arguments{
\item{snr}{the population Signal Noise ratio. Often one will use
the population estimate instead.}

\item{n}{the sample size that the Shapre ratio is observed on.}

\item{cumulants}{a vector of the third through fourth, or the third
through seventh population cumulants of the random variable.
More terms are needed for the higher accuracy approximation.}

\item{type}{determines the order of accuracy of the bias approximation.
Takes values of
\describe{
\item{simple}{We compute the simple approximation using only the skewness
and excess kurtosis.}
\item{second_order}{We compute the more accurate approximation, given by
Bao, which is accurate to \eqn{o\left(n^{-2}\right)}.}
}}
}
\value{
the approximate bias of the Sharpe ratio. The bias is the
expected value of the sample Sharpe minus the Signal Noise ratio.
}
\description{
Computes the asymptotic bias of the sample Sharpe ratio based on moments.
}
\details{
The sample Sharpe ratio has bias of the form
\deqn{B = \left(\frac{3}{4n} + 3 \frac{\gamma_2}{8n}\right) \zeta - 
\frac{1}{2n} \gamma_1 + o\left(n^{-3/2}\right),}
where \eqn{\zeta} is the population Signal Noise ratio, 
\eqn{n} is the sample size, \eqn{\gamma_1} is the population skewness,
and \eqn{\gamma_2} is the population excess kurtosis.
This form of the bias appears as Equation (5) in Bao, which
claims an accuracy of only \eqn{o\left(n^{-1}\right)}. The
author believes this approximation is slightly more accurate.

A more accurate form is given by Bao (Equation (3)) as 
\deqn{B = \frac{3\zeta}{4n}\zeta + \frac{49\zeta}{32n^2} - \gamma_1 \left(\frac{1}{2n} + \frac{3}{8n^2}\right) + \gamma_2 \zeta
\left(\frac{3}{8n} - \frac{15}{32n^2}\right) + \frac{3\gamma_3}{8n^2} - \frac{5\gamma_4 \zeta}{16n^2} - \frac{5\gamma_1^2\zeta}{4n^2}
+ \frac{105\gamma_2^2 \zeta}{128 n^2} - \frac{15 \gamma_1 \gamma_2}{16n^2} + o\left(n^{-2}\right),}
where \eqn{\gamma_3} through \eqn{\gamma_5} are the fifth through
seventh cumulants of the error term.
}
\note{
much of the code is adapted from Gauss code provided by Yong Bao.
}
\examples{

# bias under normality:
sr_bias(1, 100, rep(0,2), type='simple')
sr_bias(1, 100, rep(0,5), type='second_order')

# plugging in sample estimates
x <- rnorm(1000)
n <- length(x)
mu <- mean(x)
sdv <- sd(x)
snr <- mu / sdv
# these are not great estimates, but close enough:
sku <- mean((x-mu)^3) / sdv^3
kur <- (mean((x-mu)^4) / sdv^4) - 4
sr_bias(snr, n, c(sku,kur), type='simple')

}
\references{
Bao, Yong. "Estimation Risk-Adjusted Sharpe Ratio and Fund Performance Ranking 
Under a General Return Distribution." Journal of Financial Econometrics 7, 
no. 2 (2009): 152-173. \url{https://doi.org/10.1093/jjfinec/nbn022}
}
\seealso{
\code{\link{sr_variance}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
